/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ConfiguratorImpl;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishImpl
implements GlassFish {
    private ModuleStartup gfKernel;
    private Habitat habitat;
    volatile GlassFish.Status status = GlassFish.Status.INIT;

    public GlassFishImpl(ModuleStartup gfKernel, Habitat habitat, Properties gfProps) throws GlassFishException {
        this.gfKernel = gfKernel;
        this.habitat = habitat;
        this.configure(gfProps);
    }

    private void configure(Properties gfProps) throws GlassFishException {
        ConfiguratorImpl configurator = new ConfiguratorImpl(this.habitat);
        configurator.configure(gfProps);
    }

    @Override
    public synchronized void start() throws GlassFishException {
        if (this.status == GlassFish.Status.STARTED) {
            return;
        }
        try {
            this.status = GlassFish.Status.STARTING;
            this.gfKernel.start();
            this.status = GlassFish.Status.STARTED;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public synchronized void stop() throws GlassFishException {
        if (this.status != GlassFish.Status.STARTED) {
            return;
        }
        try {
            this.status = GlassFish.Status.STOPPING;
            this.gfKernel.stop();
            this.status = GlassFish.Status.STOPPED;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public synchronized void dispose() throws GlassFishException {
        if (this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already disposed.");
        }
        if (this.status != GlassFish.Status.STOPPED) {
            this.stop();
        }
        this.gfKernel = null;
        this.habitat = null;
        this.status = GlassFish.Status.DISPOSED;
    }

    @Override
    public synchronized GlassFish.Status getStatus() {
        return this.status;
    }

    @Override
    public <T> T getService(Class<T> serviceType) throws GlassFishException {
        return this.getService(serviceType, null);
    }

    @Override
    public synchronized <T> T getService(Class<T> serviceType, String serviceName) throws GlassFishException {
        if (this.status != GlassFish.Status.STARTED) {
            throw new IllegalArgumentException("Server is not started yet. It is in " + (Object)((Object)this.status) + "state");
        }
        return (T)(serviceName != null ? this.habitat.getComponent(serviceType, serviceName) : this.habitat.getComponent(serviceType));
    }

    @Override
    public Deployer getDeployer() throws GlassFishException {
        return this.getService(Deployer.class);
    }

    @Override
    public CommandRunner getCommandRunner() throws GlassFishException {
        return this.getService(CommandRunner.class);
    }
}

