/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class GrizzlyConfigSchemaMigrator
implements ConfigurationUpgrade,
PostConstruct {
    private static final String SSL_CONFIGURATION_WANTAUTH = "com.sun.grizzly.ssl.auth";
    private static final String SSL_CONFIGURATION_SSLIMPL = "com.sun.grizzly.ssl.sslImplementation";
    @Inject
    private Configs configs;
    @Inject
    private Habitat habitat;
    private static final String HTTP_THREAD_POOL = "http-thread-pool";
    private static final String ASADMIN_LISTENER = "admin-listener";
    private static final String ASADMIN_VIRTUAL_SERVER = "__asadmin";

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            try {
                this.rectifyThreadPools(config);
                this.processHttpListeners(config);
                this.promoteHttpServiceProperties(config.getHttpService());
                this.promoteVirtualServerProperties(config.getHttpService());
                this.promoteSystemProperties();
                if (config.getName().equals("server-config")) continue;
                this.addAsadminProtocol(config.getNetworkConfig());
            }
            catch (PropertyVetoException pve) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading domain.xml.", pve);
                throw new RuntimeException(pve);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading domain.xml.", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private void promoteSystemProperties() throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

            public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                ArrayList props = new ArrayList(param.getJvmOptions());
                Iterator iterator = props.iterator();
                while (iterator.hasNext()) {
                    String[] parts;
                    String name;
                    String prop = (String)iterator.next();
                    if (!prop.startsWith("-D") || !GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(name = (parts = prop.split("="))[0].substring(2)) && !GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(name)) continue;
                    iterator.remove();
                    GrizzlyConfigSchemaMigrator.this.updateSsl(name, parts[1]);
                }
                param.setJvmOptions(props);
                return param;
            }
        }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getByType(JavaConfig.class)));
    }

    private void updateSsl(final String propName, final String value) throws TransactionFailure {
        Collection protocols = this.habitat.getAllByContract(Protocol.class);
        for (Protocol protocol : protocols) {
            Ssl ssl = protocol.getSsl();
            if (ssl == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Ssl>(){

                public Object run(Ssl param) {
                    if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(propName)) {
                        param.setClientAuth(value);
                    } else if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(propName)) {
                        param.setClassname(value);
                    }
                    return param;
                }
            }, (ConfigBeanProxy)ssl);
        }
    }

    private void rectifyThreadPools(Config config) throws TransactionFailure {
        NetworkListeners networkListeners;
        ThreadPools threadPools = config.getThreadPools();
        if (threadPools == null) {
            threadPools = this.createThreadPools(config);
        } else {
            List<ThreadPool> list = threadPools.getThreadPool();
            int[] count = new int[]{1};
            for (ThreadPool pool : list) {
                if (pool.getName() != null) continue;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                    public Object run(ThreadPool param) {
                        param.setName(param.getThreadPoolId());
                        if (param.getMinThreadPoolSize() == null || Integer.parseInt(param.getMinThreadPoolSize()) < 2) {
                            param.setMinThreadPoolSize("2");
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)pool);
            }
        }
        NetworkConfig networkConfig = config.getNetworkConfig();
        if (networkConfig != null && (networkListeners = networkConfig.getNetworkListeners()) != null && networkListeners.getThreadPool() != null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws TransactionFailure {
                    GrizzlyConfigSchemaMigrator.this.migrateThreadPools(param);
                    return null;
                }
            }, (ConfigBeanProxy)threadPools);
        }
        if (this.habitat.getComponent(ThreadPool.class, HTTP_THREAD_POOL) == null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws TransactionFailure {
                    List<ThreadPool> list = param.getThreadPool();
                    ThreadPool pool = (ThreadPool)param.createChild(ThreadPool.class);
                    pool.setName(GrizzlyConfigSchemaMigrator.HTTP_THREAD_POOL);
                    pool.setMaxQueueSize("4096");
                    list.add(pool);
                    return pool;
                }
            }, (ConfigBeanProxy)config.getThreadPools());
        }
    }

    private void promoteVirtualServerProperties(HttpService service) throws TransactionFailure {
        for (VirtualServer virtualServer : service.getVirtualServer()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer param) throws PropertyVetoException {
                    if (param.getHttpListeners() != null && !"".equals(param.getHttpListeners())) {
                        param.setNetworkListeners(param.getHttpListeners());
                    }
                    param.setHttpListeners(null);
                    ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                    Iterator it = propertyList.iterator();
                    while (it.hasNext()) {
                        Property property = (Property)it.next();
                        if ("docroot".equals(property.getName())) {
                            param.setDocroot(property.getValue());
                            it.remove();
                            continue;
                        }
                        if ("accesslog".equals(property.getName())) {
                            param.setAccessLog(property.getValue());
                            it.remove();
                            continue;
                        }
                        if (!"sso-enabled".equals(property.getName())) continue;
                        param.setSsoEnabled(property.getValue());
                        it.remove();
                    }
                    param.getProperty().clear();
                    param.getProperty().addAll(propertyList);
                    return null;
                }
            }, (ConfigBeanProxy)virtualServer);
        }
    }

    private void promoteHttpServiceProperties(HttpService service) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) {
                ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                Iterator it = propertyList.iterator();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    if ("accessLoggingEnabled".equals(property.getName())) {
                        param.setAccessLoggingEnabled(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogBufferSize".equals(property.getName())) {
                        param.getAccessLog().setBufferSizeBytes(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogWriterInterval".equals(property.getName())) {
                        param.getAccessLog().setWriteIntervalSeconds(property.getValue());
                        it.remove();
                        continue;
                    }
                    if (!"sso-enabled".equals(property.getName())) continue;
                    param.setSsoEnabled(property.getValue());
                    it.remove();
                }
                param.getProperty().clear();
                param.getProperty().addAll(propertyList);
                return null;
            }
        }, (ConfigBeanProxy)service);
    }

    private void processHttpListeners(Config config) throws PropertyVetoException, TransactionFailure {
        if (!config.getHttpService().getHttpListener().isEmpty()) {
            this.migrateSettings(config);
        }
    }

    private void migrateThreadPools(ThreadPools threadPools) throws TransactionFailure {
        Config config = (Config)threadPools.getParent(Config.class);
        NetworkListeners networkListeners = config.getNetworkConfig().getNetworkListeners();
        threadPools.getThreadPool().addAll(networkListeners.getThreadPool());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) {
                param.getThreadPool().clear();
                return null;
            }
        }, (ConfigBeanProxy)networkListeners);
    }

    private ThreadPools createThreadPools(Config config) throws TransactionFailure {
        return (ThreadPools)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

            public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                ThreadPools threadPools = (ThreadPools)param.createChild(ThreadPools.class);
                param.setThreadPools(threadPools);
                return threadPools;
            }
        }, (ConfigBeanProxy)config);
    }

    private void migrateSettings(Config config) throws PropertyVetoException, TransactionFailure {
        HttpService service = config.getHttpService();
        NetworkConfig networkConfig = this.getNetworkConfig(config);
        this.migrateHttpListeners(config, networkConfig);
        this.migrateHttpProtocol(networkConfig, service);
        this.migrateHttpFileCache(networkConfig, service);
        this.migrateRequestProcessing(networkConfig, service);
        this.migrateKeepAlive(networkConfig, service);
        this.migrateConnectionPool(networkConfig, service);
    }

    private void migrateConnectionPool(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final ConnectionPool pool = httpService.getConnectionPool();
        if (pool == null) {
            return;
        }
        Transport transport = (Transport)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

            public Object run(Transports param) throws TransactionFailure {
                Transport transport = (Transport)param.createChild(Transport.class);
                param.getTransport().add(transport);
                transport.setMaxConnectionsCount(pool.getMaxPendingCount());
                transport.setName("tcp");
                return transport;
            }
        }, (ConfigBeanProxy)this.getTransports(config));
        this.updateNetworkListener(config, transport);
        this.updateHttp(config, pool);
        this.updateThreadPool(config, pool);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setConnectionPool(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void updateThreadPool(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        for (ThreadPool threadPool : config.getNetworkListeners().getThreadPool()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                public Object run(ThreadPool param) {
                    param.setMaxQueueSize(pool.getQueueSizeInBytes());
                    if (param.getMinThreadPoolSize() == null || Integer.parseInt(param.getMinThreadPoolSize()) < 2) {
                        param.setMinThreadPoolSize("2");
                    }
                    return null;
                }
            }, (ConfigBeanProxy)threadPool);
        }
    }

    private void updateHttp(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http http) {
                    http.setSendBufferSizeBytes(pool.getSendBufferSizeInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getHttp());
        }
    }

    private void updateNetworkListener(NetworkConfig config, final Transport transport) throws TransactionFailure {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setTransport(transport.getName());
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
    }

    private Transports getTransports(NetworkConfig config) throws TransactionFailure {
        Transports listeners = config.getTransports();
        if (listeners == null) {
            listeners = (Transports)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Transports child = (Transports)param.createChild(Transports.class);
                    param.setTransports(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return listeners;
    }

    private void migrateKeepAlive(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final KeepAlive keepAlive = httpService.getKeepAlive();
        if (keepAlive == null) {
            return;
        }
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http http) {
                    http.setMaxConnections(keepAlive.getMaxConnections());
                    http.setTimeoutSeconds(keepAlive.getTimeoutInSeconds());
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getHttp());
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setKeepAlive(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateRequestProcessing(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final RequestProcessing request = httpService.getRequestProcessing();
        if (request == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

            public Object run(ThreadPool pool) throws PropertyVetoException, TransactionFailure {
                pool.setMaxThreadPoolSize(request.getThreadCount());
                pool.setMinThreadPoolSize(request.getInitialThreadCount());
                if (pool.getMinThreadPoolSize() == null || Integer.parseInt(pool.getMinThreadPoolSize()) < 2) {
                    pool.setMinThreadPoolSize("2");
                }
                return null;
            }
        }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getComponent(ThreadPool.class, HTTP_THREAD_POOL)));
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setThreadPool(GrizzlyConfigSchemaMigrator.HTTP_THREAD_POOL);
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http http) {
                    http.setHeaderBufferLengthBytes(request.getHeaderBufferLengthInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getHttp());
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setRequestProcessing(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpFileCache(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final HttpFileCache httpFileCache = httpService.getHttpFileCache();
        if (httpFileCache == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig param) throws TransactionFailure {
                for (Protocol protocol : param.getProtocols().getProtocol()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) throws TransactionFailure {
                            FileCache cache = (FileCache)http.createChild(FileCache.class);
                            http.setFileCache(cache);
                            cache.setEnabled(httpFileCache.getFileCachingEnabled());
                            cache.setMaxAgeSeconds(httpFileCache.getMaxAgeInSeconds());
                            cache.setMaxCacheSizeBytes(httpFileCache.getMediumFileSpaceInBytes());
                            cache.setMaxFilesCount(httpFileCache.getMaxFilesCount());
                            return null;
                        }
                    }, (ConfigBeanProxy)protocol.getHttp());
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpFileCache(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpProtocol(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final HttpProtocol httpProtocol = httpService.getHttpProtocol();
        if (httpProtocol == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig param) throws TransactionFailure {
                for (Protocol protocol : param.getProtocols().getProtocol()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) {
                            http.setVersion(httpProtocol.getVersion());
                            http.setDnsLookupEnabled(httpProtocol.getDnsLookupEnabled());
                            http.setForcedResponseType(null);
                            http.setDefaultResponseType(null);
                            return null;
                        }
                    }, (ConfigBeanProxy)protocol.getHttp());
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpProtocol(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpListeners(Config baseConfig, NetworkConfig config) throws TransactionFailure {
        for (final HttpListener listener : baseConfig.getHttpService().getHttpListener()) {
            Protocol protocol = this.migrateToProtocols(config, listener);
            this.createNetworkListener(baseConfig, listener, protocol);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) {
                    HttpListener listener1 = param.getHttpListenerById(listener.getId());
                    param.getHttpListener().remove(listener1);
                    return null;
                }
            }, (ConfigBeanProxy)baseConfig.getHttpService());
        }
    }

    private NetworkConfig getNetworkConfig(Config baseConfig) throws TransactionFailure {
        NetworkConfig config = baseConfig.getNetworkConfig();
        if (config == null) {
            config = (NetworkConfig)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                    NetworkConfig child = (NetworkConfig)param.createChild(NetworkConfig.class);
                    param.setNetworkConfig(child);
                    return child;
                }
            }, (ConfigBeanProxy)baseConfig);
        }
        return config;
    }

    private void createNetworkListener(Config baseConfig, final HttpListener listener, final Protocol protocol) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) throws TransactionFailure {
                NetworkListener netListener = (NetworkListener)param.createChild(NetworkListener.class);
                netListener.setName(listener.getId());
                netListener.setEnabled(listener.getEnabled());
                netListener.setAddress(listener.getAddress());
                netListener.setPort(listener.getPort());
                netListener.setProtocol(protocol.getName());
                param.getNetworkListener().add(netListener);
                return null;
            }
        }, (ConfigBeanProxy)this.getNetworkListeners(baseConfig.getNetworkConfig()));
    }

    private NetworkListeners getNetworkListeners(NetworkConfig config) throws TransactionFailure {
        NetworkListeners listeners = config.getNetworkListeners();
        if (listeners == null) {
            listeners = (NetworkListeners)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    NetworkListeners child = (NetworkListeners)param.createChild(NetworkListeners.class);
                    param.setNetworkListeners(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return listeners;
    }

    private Protocol migrateToProtocols(NetworkConfig config, final HttpListener listener) throws TransactionFailure {
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                Ssl ssl = listener.getSsl();
                param.getProtocol().add(protocol);
                protocol.setName(listener.getId());
                protocol.setSsl(ssl);
                protocol.setSecurityEnabled(listener.getSecurityEnabled());
                GrizzlyConfigSchemaMigrator.this.createHttp(protocol, listener);
                return protocol;
            }
        }, (ConfigBeanProxy)protocols);
    }

    public static Protocols getProtocols(NetworkConfig config) throws TransactionFailure {
        Protocols protocols = config.getProtocols();
        if (protocols == null) {
            protocols = (Protocols)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Protocols child = (Protocols)param.createChild(Protocols.class);
                    param.setProtocols(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return protocols;
    }

    private void createHttp(Protocol protocol, HttpListener listener) throws TransactionFailure {
        Http http = (Http)protocol.createChild(Http.class);
        http.setFileCache((FileCache)http.createChild(FileCache.class));
        protocol.setHttp(http);
        http.setDefaultVirtualServer(listener.getDefaultVirtualServer());
        http.setServerName(listener.getServerName());
        http.setRedirectPort(listener.getRedirectPort());
        http.setXpoweredBy(listener.getXpoweredBy());
    }

    private Protocol addAsadminProtocol(NetworkConfig config) throws TransactionFailure {
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                param.getProtocol().add(protocol);
                protocol.setName(GrizzlyConfigSchemaMigrator.ASADMIN_LISTENER);
                Http http = (Http)protocol.createChild(Http.class);
                http.setFileCache((FileCache)http.createChild(FileCache.class));
                protocol.setHttp(http);
                http.setDefaultVirtualServer(GrizzlyConfigSchemaMigrator.ASADMIN_VIRTUAL_SERVER);
                http.setMaxConnections("250");
                return protocol;
            }
        }, (ConfigBeanProxy)protocols);
    }
}

