/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.StaticGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static Logger logger = Util.getLogger();
    private static final String JAR_EXT = ".jar";

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        String installRoot = this.getInstallRoot(bsProps);
        if (installRoot != null) {
            System.setProperty("org.glassfish.embeddable.installRoot", installRoot);
        }
        List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
        StaticClassLoader cl = new StaticClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
        EmbeddedMain main = new EmbeddedMain();
        SingleHK2Factory.initialize(cl);
        ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
        modulesRegistry.setParentClassLoader((ClassLoader)cl);
        StaticGlassFishRuntime glassFishRuntime = new StaticGlassFishRuntime(main);
        logger.logp(Level.FINER, this.getClass().getName(), "build", "Created GlassFishRuntime {0} with InstallRoot {1}, Bootstrap Options {2}", new Object[]{glassFishRuntime, installRoot, bsProps});
        return glassFishRuntime;
    }

    @Override
    public boolean handles(BootstrapProperties bsProps) {
        String platform = bsProps.getProperty("GlassFish_Platform");
        return platform == null || Constants.Platform.Static.toString().equalsIgnoreCase(platform);
    }

    private String getInstallRoot(BootstrapProperties props) {
        File installRoot;
        String installRootProp = props.getInstallRoot();
        if (installRootProp == null && this.isValidInstallRoot(installRoot = ASMainHelper.findInstallRoot())) {
            installRootProp = installRoot.getAbsolutePath();
        }
        return installRootProp;
    }

    private boolean isValidInstallRoot(File installRoot) {
        return installRoot == null ? false : this.isValidInstallRoot(installRoot.getAbsolutePath());
    }

    private List<URL> getModuleJarURLs(String installRoot) {
        if (installRoot == null) {
            return new ArrayList<URL>();
        }
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        modulesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(StaticGlassFishRuntimeBuilder.JAR_EXT)) {
                    try {
                        moduleJarURLs.add(pathname.toURI().toURL());
                    }
                    catch (Exception ex) {
                        logger.warning(ex.getMessage());
                    }
                }
                return false;
            }
        });
        return moduleJarURLs;
    }

    private boolean isValidInstallRoot(String installRootPath) {
        if (installRootPath == null || !new File(installRootPath).exists()) {
            return false;
        }
        if (!new File(installRootPath, "modules").exists()) {
            return false;
        }
        return new File(installRootPath, "lib/dtds").exists();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticClassLoader
    extends URLClassLoader {
        public StaticClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super(moduleJarURLs.toArray(new URL[0]), parent);
        }
    }
}

