/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.embeddable;

import com.sun.enterprise.admin.cli.embeddable.CommandExecutorImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFishException;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
@ContractProvided(value=Deployer.class)
public class DeployerImpl
implements Deployer {
    @Inject
    Habitat habitat;

    @Override
    public String deploy(URI archive, String ... params) throws GlassFishException {
        if (!"file".equalsIgnoreCase(archive.getScheme())) {
            throw new UnsupportedOperationException("Currently only file protocol is supported");
        }
        File file = new File(archive);
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = file.getAbsolutePath();
        CommandExecutorImpl executer = (CommandExecutorImpl)this.habitat.getComponent(CommandExecutorImpl.class);
        try {
            ActionReport actionReport = executer.executeCommand("deploy", newParams);
            actionReport.writeReport((OutputStream)System.out);
            return (String)actionReport.getResultType(String.class);
        }
        catch (CommandException e) {
            throw new GlassFishException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public String deploy(File file, String ... params) throws GlassFishException {
        return this.deploy(file.toURI(), params);
    }

    @Override
    public void undeploy(String appName, String ... params) throws GlassFishException {
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = appName;
        CommandExecutorImpl executer = (CommandExecutorImpl)this.habitat.getComponent(CommandExecutorImpl.class);
        try {
            ActionReport actionReport = executer.executeCommand("undeploy", newParams);
            actionReport.writeReport((OutputStream)System.out);
        }
        catch (CommandException e) {
            throw new GlassFishException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public Collection<String> getDeployedApplications() throws GlassFishException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

