/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainNonOSGi;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.MaskingClassLoader;
import com.sun.enterprise.glassfish.bootstrap.Rejar;
import com.sun.enterprise.glassfish.bootstrap.StartupContextUtil;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.single.SingleModulesRegistry;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsParserDecorator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainStatic
extends ASMainNonOSGi {
    private File out;
    private Habitat habitat;
    private File glassfishDir;
    private File domainDir;

    protected String getPreferedCacheDir() {
        return "static-cache/gf/";
    }

    public String getName() {
        return Constants.Platform.Static.toString();
    }

    public <T> T getStartedService(Class<T> serviceType) {
        if (this.habitat != null) {
            return (T)this.habitat.getComponent(serviceType);
        }
        return null;
    }

    public void start(Properties args) throws Exception {
        StartupContext sc = (StartupContext)this.getContext(StartupContext.class);
        if (sc == null) {
            sc = new StartupContext(args);
        }
        super.setContext((Object)sc);
        this.glassfishDir = StartupContextUtil.getInstallRoot(sc);
        this.domainDir = StartupContextUtil.getInstanceRoot(sc);
        File modulesDir = new File(this.glassfishDir, "modules");
        StartupContext startupContext = sc;
        this.configureEnvironment();
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader maskingClassLoade = ASMainStatic.getMaskingClassLoader(parent, this.glassfishDir, this.logger);
        ClassLoader singleClassLoader = this.createTmpClassLoader(maskingClassLoade, modulesDir);
        if (singleClassLoader == null) {
            throw new BootException("Could not create single class loader from the cache");
        }
        SingleModulesRegistry modulesRegistry = new SingleModulesRegistry(singleClassLoader);
        modulesRegistry.setParentClassLoader(singleClassLoader);
        final ClassLoader cl = singleClassLoader;
        Thread launcherThread = new Thread(new Runnable((ModulesRegistryImpl)modulesRegistry, startupContext){
            final /* synthetic */ ModulesRegistryImpl val$modulesRegistry;
            final /* synthetic */ StartupContext val$startupContext;
            {
                this.val$modulesRegistry = modulesRegistryImpl;
                this.val$startupContext = startupContext;
            }

            public void run() {
                Main main = new Main(){

                    public Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
                        Habitat habitat = registry.newHabitat();
                        for (Object c : ASMainStatic.this.getContexts()) {
                            habitat.add(Inhabitants.create(c));
                        }
                        habitat.add((Inhabitant)new ExistingSingletonInhabitant(ModulesRegistry.class, (Object)registry));
                        habitat.add((Inhabitant)new ExistingSingletonInhabitant(Logger.class, (Object)ASMainStatic.this.logger));
                        registry.createHabitat("default", this.createInhabitantsParser(habitat));
                        ASMainStatic.this.habitat = habitat;
                        return habitat;
                    }

                    protected InhabitantsParser createInhabitantsParser(Habitat habitat) {
                        InhabitantsParser parser = super.createInhabitantsParser(habitat);
                        ServiceLoader<InhabitantsParserDecorator> decorators = ServiceLoader.load(InhabitantsParserDecorator.class, cl);
                        for (InhabitantsParserDecorator decorator : decorators) {
                            decorator.decorate(parser);
                        }
                        return parser;
                    }
                };
                try {
                    main.launch((ModulesRegistry)this.val$modulesRegistry, this.val$startupContext);
                }
                catch (BootException e) {
                    ASMainStatic.this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }, "Static Framework Launcher");
        launcherThread.setContextClassLoader(singleClassLoader);
        launcherThread.setDaemon(true);
        launcherThread.start();
        try {
            launcherThread.join();
        }
        catch (InterruptedException e) {
            this.logger.warning("main thread interrupted");
        }
        this.logger.fine("Framework successfully started");
    }

    private void configureEnvironment() {
        System.setProperty("com.sun.aas.installRootURI", this.glassfishDir.toURI().toString());
        System.setProperty("com.sun.aas.instanceRootURI", this.domainDir.toURI().toString());
        File cacheProfileDir = new File(this.domainDir, this.getPreferedCacheDir());
        System.setProperty("com.sun.enterprise.hk2.cacheDir", cacheProfileDir.getAbsolutePath());
    }

    protected static ClassLoader getMaskingClassLoader(ClassLoader parent, File root, Logger logger) {
        return ASMainStatic.getMaskingClassLoader(parent, root, logger, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ClassLoader getMaskingClassLoader(ClassLoader parent, File root, Logger logger, boolean useExplicitSystemClassLoaderCalls) {
        Properties props;
        block12: {
            File f = new File(root, "osgi/felix");
            if (!(f = new File(f, "conf/config.properties")).exists()) {
                return parent;
            }
            props = new Properties();
            FileReader reader = null;
            reader = new FileReader(f);
            props.load(reader);
            Object var10_7 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block12;
            }
            catch (IOException e2) {}
            break block12;
            {
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Cannot load " + f.getAbsolutePath());
                    ClassLoader classLoader = parent;
                    Object var10_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return classLoader;
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ASMainStatic.getMaskingClassLoader(parent, props, useExplicitSystemClassLoaderCalls);
    }

    public static ClassLoader getMaskingClassLoader(ClassLoader parent, Properties props) {
        return ASMainStatic.getMaskingClassLoader(parent, props, true);
    }

    public static ClassLoader getMaskingClassLoader(ClassLoader parent, Properties props, boolean useExplicitSystemClassLoaderCalls) {
        String punchins = props.getProperty("jre-1.6");
        StringTokenizer st = new StringTokenizer(punchins, ",");
        ArrayList<String> p = new ArrayList<String>();
        ArrayList<String> multiples = new ArrayList<String>();
        multiples.add("org.jvnet");
        multiples.add("org.glassfish");
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (tk.contains(";")) {
                tk = tk.substring(0, tk.indexOf(";"));
            }
            p.add(tk.trim());
        }
        return new MaskingClassLoader(parent, p, multiples, useExplicitSystemClassLoaderCalls);
    }

    @Override
    boolean createCache(File cacheDir) throws IOException {
        cacheDir.mkdirs();
        Rejar rejar = new Rejar();
        rejar.rejar(this.out, new File(this.glassfishDir, "modules/"));
        return true;
    }

    public ClassLoader createClassLoader(File cacheDir) throws Exception {
        if (this.out != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(this.out.toURI().toURL());
            this.findDerbyClient(urls);
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        return null;
    }

    public ClassLoader createTmpClassLoader(ClassLoader parent, File moduleDir) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set<ModuleInfo> modules = this.getAlreadyLoadedModules();
        this.insertURLs(moduleDir, modules, urls);
        this.findDerbyClient(urls);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    private URL getJarFileURL(URL url) throws MalformedURLException {
        String urlString = url.toExternalForm();
        return new URL(urlString.substring("jar:".length(), urlString.length() - "META-INF/MANIFEST.MF".length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ModuleInfo> getAlreadyLoadedModules() throws IOException {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
        Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
        while (urls.hasMoreElements()) {
            IOException e2;
            Object var8_7;
            InputStream is = null;
            URL url = urls.nextElement();
            try {
                is = url.openStream();
                Manifest m = new Manifest(is);
                if (m.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                    modules.add(new ModuleInfo(m.getMainAttributes().getValue("Bundle-SymbolicName"), m.getMainAttributes().getValue("Bundle-Version")));
                }
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is == null) continue;
                is.close();
            }
            catch (IOException e2) {}
        }
        return modules;
    }

    private void insertURLs(File directory, Set<ModuleInfo> modules, List<URL> result) throws Exception {
        for (File file : directory.listFiles()) {
            if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                this.processFile(file, modules, result);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.insertURLs(file, modules, result);
        }
    }

    private void processFile(File file, Set<ModuleInfo> modules, List<URL> result) throws IOException {
        JarFile jarFile = new JarFile(file);
        Manifest m = jarFile.getManifest();
        String bundleName = m.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName != null) {
            String version = m.getMainAttributes().getValue("Bundle-Version");
            ModuleInfo info = new ModuleInfo(bundleName, version);
            if (!modules.contains(info)) {
                result.add(file.toURI().toURL());
                modules.add(info);
            }
        } else {
            result.add(file.toURI().toURL());
        }
        String classpath = m.getMainAttributes().getValue("Class-Path");
        if (classpath != null) {
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String cpe = st.nextToken();
            }
        }
    }

    private void findDerbyClient(List<URL> urls) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.fine("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        urls.add(new File(derbyLib, "derby.jar").toURI().toURL());
        urls.add(new File(derbyLib, "derbyclient.jar").toURI().toURL());
    }

    private final class ModuleInfo {
        final String bundleName;
        final String bundleVersion;

        private ModuleInfo(String bundleName, String bundleVersion) {
            this.bundleName = bundleName;
            this.bundleVersion = bundleVersion;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModuleInfo)) {
                return false;
            }
            ModuleInfo o = (ModuleInfo)other;
            return this.bundleName.equals(o.bundleName) && this.bundleVersion.equals(o.bundleVersion);
        }
    }
}

