/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;

public class AutoProcessor {
    public static final String AUTO_INSTALL_PROP = "glassfish.auto.install";
    public static final String AUTO_START_PROP = "glassfish.auto.start";

    public static void process(Map configMap, BundleContext context) {
        configMap = configMap == null ? new HashMap() : configMap;
        AutoProcessor.processAutoProperties(configMap, context);
    }

    private static void processAutoProperties(Map configMap, BundleContext context) {
        String key;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        Iterator i = configMap.keySet().iterator();
        while (i.hasNext()) {
            key = ((String)i.next()).toLowerCase();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            if (!key.equals(AUTO_INSTALL_PROP) && !key.equals(AUTO_START_PROP)) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
        i = configMap.keySet().iterator();
        while (i.hasNext()) {
            key = ((String)i.next()).toLowerCase();
            if (!key.startsWith(AUTO_START_PROP)) continue;
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    if (b != null) {
                        b.start();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }
}

