/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class GlassFishActivator
implements BundleActivator,
EventListener {
    private BundleContext bundleContext;
    private Events events;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.startBundles();
        this.registerGlassFishRuntime();
    }

    private void registerGlassFishRuntime() throws InterruptedException {
        this.bundleContext.registerService(GlassFishRuntime.class.getName(), (Object)new GlassFishRuntime(){
            List<GlassFish> gfs = new ArrayList<GlassFish>();
            Framework framework = (Framework)GlassFishActivator.access$000(GlassFishActivator.this).getBundle(0L);

            public synchronized GlassFish newGlassFish(GlassFishProperties gfProps) throws GlassFishException {
                try {
                    GlassFishActivator.this.setEnv(gfProps.getProperties());
                    StartupContext startupContext = new StartupContext(gfProps.getProperties());
                    ServiceTracker hk2Tracker = new ServiceTracker(GlassFishActivator.this.bundleContext, Main.class.getName(), null);
                    hk2Tracker.open();
                    Main main = (Main)hk2Tracker.waitForService(0L);
                    hk2Tracker.close();
                    ModulesRegistry mr = (ModulesRegistry)ModulesRegistry.class.cast(GlassFishActivator.this.bundleContext.getService(GlassFishActivator.this.bundleContext.getServiceReference(ModulesRegistry.class.getName())));
                    Habitat habitat = main.createHabitat(mr, startupContext);
                    ModuleStartup gfKernel = main.findStartupService(mr, habitat, null, startupContext);
                    GlassFishImpl glassFish = new GlassFishImpl(gfKernel, habitat, gfProps.getProperties());
                    this.gfs.add((GlassFish)glassFish);
                    GlassFishActivator.this.events = (Events)habitat.getComponent(Events.class);
                    GlassFishActivator.this.events.register(GlassFishActivator.this);
                    GlassFishActivator.this.bundleContext.registerService(GlassFish.class.getName(), (Object)glassFish, (Dictionary)gfProps.getProperties());
                    return glassFish;
                }
                catch (BootException ex) {
                    throw new GlassFishException((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    throw new GlassFishException((Throwable)ex);
                }
            }

            public synchronized void shutdown() throws GlassFishException {
                if (this.framework == null) {
                    return;
                }
                for (GlassFish gf : this.gfs) {
                    if (gf.getStatus() == GlassFish.Status.DISPOSED) continue;
                    try {
                        gf.dispose();
                    }
                    catch (GlassFishException e) {
                        e.printStackTrace();
                    }
                }
                this.gfs.clear();
                try {
                    this.framework.stop();
                    this.framework.waitForStop(0L);
                }
                catch (InterruptedException ex) {
                    throw new GlassFishException((Throwable)ex);
                }
                catch (BundleException ex) {
                    throw new GlassFishException((Throwable)ex);
                }
                1.shutdownInternal();
                this.framework = null;
                System.out.println("Completed shutdown of GlassFish runtime");
            }
        }, null);
    }

    private Properties dict2Properties(Dictionary dictionary) {
        Properties args = new Properties();
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            String v = dictionary.get(k).toString();
            args.put(k, v);
        }
        return args;
    }

    public void stop(BundleContext context) throws Exception {
        this.stopBundle("com.sun.enterprise.osgi-adapter");
    }

    private void setEnv(Properties properties) {
        String instanceRootValue;
        String installRootValue = properties.getProperty("com.sun.aas.installRoot");
        if (installRootValue != null && !installRootValue.isEmpty()) {
            File installRoot = new File(installRootValue);
            System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            Properties asenv = ASMainHelper.parseAsEnv((File)installRoot);
            for (String s : asenv.stringPropertyNames()) {
                System.setProperty(s, asenv.getProperty(s));
            }
            System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if ((instanceRootValue = properties.getProperty("com.sun.aas.instanceRoot")) != null && !instanceRootValue.isEmpty()) {
            File instanceRoot = new File(instanceRootValue);
            System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
    }

    private void startBundles() {
        this.startConfigAdmin();
        this.startBundle("org.glassfish.hk2.osgi-resource-locator");
        this.startBundle("com.sun.enterprise.osgi-adapter");
    }

    private void startPostStartupBundles() {
        String gosh_args = "gosh.args";
        if (this.bundleContext.getProperty("gosh.args") == null) {
            String gosh_args_value = "--noshutdown -c noop=true";
            System.setProperty("gosh.args", "--noshutdown -c noop=true");
        }
        this.startBundle("org.apache.felix.shell");
        this.startBundle("org.apache.felix.gogo.runtime");
        this.startBundle("org.apache.felix.gogo.shell");
        this.startBundle("org.apache.felix.gogo.command");
        this.startBundle("org.apache.felix.shell.remote");
        this.startBundle("org.apache.felix.fileinstall");
    }

    private void startConfigAdmin() {
        ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (sr == null) {
            this.startBundle("org.apache.felix.configadmin");
        } else {
            this.bundleContext.ungetService(sr);
        }
    }

    private void startBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.start(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to start: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private void stopBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.stop(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to stop: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private Bundle findBundle(String bsn) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!bsn.equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (this.events != null) {
                this.events.unregister(this);
                this.events = null;
            }
            new Thread(){

                public void run() {
                    GlassFishActivator.this.startPostStartupBundles();
                }
            }.start();
        }
    }
}

