/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigRefValidator
implements ConstraintValidator<ConfigRefConstraint, Server>,
Payload {
    static final Logger logger = LogDomains.getLogger(ConfigRefValidator.class, (String)"javax.enterprise.system.tools.admin");
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigRefValidator.class);

    public void initialize(ConfigRefConstraint constraint) {
    }

    public boolean isValid(Server server, ConstraintValidatorContext constraintValidatorContext) {
        if (server == null) {
            return true;
        }
        String configRef = server.getConfigRef();
        if (configRef == null) {
            return true;
        }
        String serverName = server.getName();
        if (server.isDas() && !configRef.equals("server-config")) {
            logger.warning(localStrings.getLocalString("configref.dasconfig", "The configuration of the Domain Administration Server cannot be changed from server-config."));
            return false;
        }
        if (!server.isDas() && configRef.equals("server-config")) {
            logger.warning(localStrings.getLocalString("configref.serverconfig", "The configuration of the Domain Administration Server (named server-config) cannot be referenced by a server."));
            return false;
        }
        if (configRef.equals("default-config")) {
            logger.warning(localStrings.getLocalString("configref.defaultconfig", "The default configuration template (named default-config) cannot be referenced by a server."));
            return false;
        }
        Servers servers = (Servers)server.getParent(Servers.class);
        Domain domain = (Domain)servers.getParent(Domain.class);
        Configs configs = domain.getConfigs();
        if (servers.getServer(serverName) != null) {
            Cluster cluster = domain.getClusterForInstance(serverName);
            if (cluster != null && !cluster.getConfigRef().equals(configRef)) {
                logger.warning(localStrings.getLocalString("configref.clusteredinstance", "Cannot change a config-ref when the instance is part of a cluster."));
                return false;
            }
            if (configs == null || configs.getConfigByName(configRef) == null) {
                logger.warning(localStrings.getLocalString("configref.nonexistent", "A configuration that doesn't exist cannot be referenced by a server."));
                return false;
            }
        }
        return true;
    }
}

