/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfigInfo {
    private final Map<String, Map<String, ApplicationConfig>> moduleToEngineToAppConfig;

    public ApplicationConfigInfo() {
        this.moduleToEngineToAppConfig = this.createNewMap();
    }

    public ApplicationConfigInfo(Properties appProperties) {
        Object map = appProperties.get("appConfig");
        this.moduleToEngineToAppConfig = map == null ? this.createNewMap() : (Map)map;
    }

    public ApplicationConfigInfo(Application app) {
        this.moduleToEngineToAppConfig = this.createNewMap();
        if (app != null) {
            for (Module m : app.getModule()) {
                for (Engine e : m.getEngines()) {
                    this.put(m.getName(), e.getSniffer(), e.getApplicationConfig());
                }
            }
        }
    }

    private Map<String, Map<String, ApplicationConfig>> createNewMap() {
        return new HashMap<String, Map<String, ApplicationConfig>>();
    }

    public <T extends ApplicationConfig> T get(String moduleName, String engineName) {
        ApplicationConfig result = null;
        Map<String, ApplicationConfig> engineToAppConfig = this.moduleToEngineToAppConfig.get(moduleName);
        if (engineToAppConfig != null) {
            result = engineToAppConfig.get(engineName);
        }
        return (T)result;
    }

    public void put(String moduleName, String engineName, ApplicationConfig appConfig) {
        Map<String, ApplicationConfig> engineToAppConfig = this.moduleToEngineToAppConfig.get(moduleName);
        if (engineToAppConfig == null) {
            engineToAppConfig = new HashMap<String, ApplicationConfig>();
            this.moduleToEngineToAppConfig.put(moduleName, engineToAppConfig);
        }
        engineToAppConfig.put(engineName, appConfig);
    }

    public Set<String> moduleNames() {
        return this.moduleToEngineToAppConfig.keySet();
    }

    public Set<String> engineNames(String moduleName) {
        return this.moduleToEngineToAppConfig.get(moduleName).keySet();
    }

    public void store(Properties appProps) {
        appProps.put("appConfig", this.moduleToEngineToAppConfig);
    }
}

