/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIManFileFinder;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCommand.class);
    private boolean returnOutput = false;
    private String output;
    private boolean returnAttributes = false;
    private Map<String, String> attrs;
    private String usage;
    private String responseFormatType;
    private OutputStream userOut;
    private File outputDir;
    private CLIRemoteAdminCommand rac;
    private static ClassLoader moduleClassLoader;
    private static Habitat manHabitat;

    public RemoteCommand() throws CommandException {
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env, String responseFormatType, OutputStream userOut) throws CommandException {
        this(name, po, env);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    public void setFileOutputDirectory(File dir) {
        this.outputDir = dir;
    }

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        try {
            this.processProgramOptions();
            this.initializeAuth();
            this.initializeRemoteAdminCommand();
            if (this.responseFormatType != null) {
                this.rac.setResponseFormatType(this.responseFormatType);
            }
            if (this.userOut != null) {
                this.rac.setUserOut(this.userOut);
            }
            if (this.programOpts.isHelp()) {
                this.commandModel = this.helpModel();
                this.rac.setCommandModel(this.commandModel);
                return;
            }
            this.commandModel = this.rac.getCommandModel();
        }
        catch (CommandException cex) {
            logger.finer("RemoteCommand.prepare throws " + (Object)((Object)cex));
            throw cex;
        }
        catch (Exception e) {
            logger.finer("RemoteCommand.prepare throws " + e);
            throw new CommandException(e.getMessage());
        }
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            return;
        }
        super.validate();
    }

    @Override
    protected boolean checkHelp() throws CommandException, CommandValidationException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        String returnVal;
        try {
            this.options.set((Object)"DEFAULT", (Collection)this.operands);
            this.output = this.rac.executeCommand(this.options);
            if (this.returnAttributes) {
                this.attrs = this.rac.getAttributes();
            } else if (!this.returnOutput && this.output.length() > 0) {
                logger.info(this.output);
            }
        }
        catch (CommandException ex) {
            Reader r;
            if (this.programOpts.isHelp() && (r = this.getLocalManPage()) != null) {
                try {
                    int cnt;
                    BufferedReader br = new BufferedReader(r);
                    PrintWriter pw = new PrintWriter(System.out);
                    char[] buf = new char[8192];
                    while ((cnt = br.read(buf)) > 0) {
                        pw.write(buf, 0, cnt);
                    }
                    pw.flush();
                    int n = 0;
                    return n;
                }
                catch (IOException ioex2) {
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException ioex3) {}
                }
            }
            throw ex;
        }
        Map racAttrs = this.rac.getAttributes();
        String string = returnVal = racAttrs != null ? (String)racAttrs.get("exit-code") : null;
        if (returnVal != null && "WARNING".equals(returnVal)) {
            return 4;
        }
        return 0;
    }

    public String executeAndReturnOutput(String ... args) throws CommandException, CommandValidationException {
        this.returnOutput = true;
        this.execute(args);
        this.returnOutput = false;
        return this.output;
    }

    public Map<String, String> executeAndReturnAttributes(String ... args) throws CommandException, CommandValidationException {
        this.returnAttributes = true;
        this.execute(args);
        this.returnAttributes = false;
        return this.attrs;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            if (this.rac == null) {
                return strings.get("Usage.asadmin.full", new Object[]{this.getName()});
            }
            this.usage = this.rac.getUsage();
        }
        if (this.usage == null) {
            return super.getUsage();
        }
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.asadmin")}));
        usageText.append(" ");
        usageText.append(this.usage);
        return usageText.toString();
    }

    @Override
    public Reader getManPage() {
        try {
            this.initializeRemoteAdminCommand();
            this.rac.setCommandModel(this.helpModel());
            ParameterMap params = new ParameterMap();
            params.set((Object)"help", (Object)"true");
            String manpage = this.rac.executeCommand(params);
            return new StringReader(manpage);
        }
        catch (CommandException cex) {
            Reader r = this.getLocalManPage();
            return r != null ? r : super.getManPage();
        }
    }

    private CommandModel helpModel() {
        CommandModelData cm = new CommandModelData(this.name);
        cm.add((CommandModel.ParamModel)new CommandModelData.ParamModelData("help", Boolean.TYPE, true, "false", "?"));
        return cm;
    }

    private Reader getLocalManPage() {
        logger.fine(strings.get("NoRemoteManPage"));
        String cmdClass = RemoteCommand.getCommandClass(this.getName());
        ClassLoader mcl = RemoteCommand.getModuleClassLoader();
        if (cmdClass != null && mcl != null) {
            return CLIManFileFinder.getCommandManFile(this.getName(), cmdClass, Locale.getDefault(), mcl);
        }
        return null;
    }

    private void initializeRemoteAdminCommand() throws CommandException {
        if (this.rac == null) {
            this.rac = new CLIRemoteAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger, this.programOpts.getAuthToken());
            this.rac.setFileOutputDirectory(this.outputDir);
        }
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.programOpts.getHost(), this.programOpts.getPort());
            if (li == null) {
                return;
            }
        }
        catch (StoreException se) {
            logger.finer("Login info could not be read from ~/.asadminpass file");
            return;
        }
        if (this.programOpts.getUser() == null) {
            logger.finer("Getting user name from ~/.asadminpass: " + li.getUser());
            this.programOpts.setUser(li.getUser());
            if (this.programOpts.getPassword() == null) {
                logger.finer("Getting password from ~/.asadminpass");
                this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
            }
        } else if (this.programOpts.getUser().equals(li.getUser()) && this.programOpts.getPassword() == null) {
            logger.finer("Getting password from ~/.asadminpass");
            this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
        }
    }

    private static String getCommandClass(String cmdName) {
        Habitat h = RemoteCommand.getManHabitat();
        String cname = "org.glassfish.api.admin.AdminCommand";
        for (Inhabitant command : h.getInhabitantsByContract(cname)) {
            for (String name : Inhabitants.getNamesFor((Inhabitant)command, (String)cname)) {
                if (!name.equals(cmdName)) continue;
                return command.typeName();
            }
        }
        return null;
    }

    private static Habitat getManHabitat() {
        if (manHabitat != null) {
            return manHabitat;
        }
        StaticModulesRegistry registry = new StaticModulesRegistry(RemoteCommand.getModuleClassLoader());
        manHabitat = registry.createHabitat("default");
        return manHabitat;
    }

    private static ClassLoader getModuleClassLoader() {
        if (moduleClassLoader != null) {
            return moduleClassLoader;
        }
        try {
            File installDir = new File(System.getProperty("com.sun.aas.installRoot"));
            File modulesDir = new File(installDir, "modules");
            moduleClassLoader = new DirectoryClassLoader(modulesDir, CLICommand.class.getClassLoader());
            return moduleClassLoader;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    private class CLIRemoteAdminCommand
    extends RemoteAdminCommand {
        public CLIRemoteAdminCommand(String name, String host, int port, boolean secure, String user, String password, Logger logger, String authToken) throws CommandException {
            super(name, host, port, secure, user, password, logger, authToken, true);
        }

        protected boolean updateAuthentication() {
            Console cons;
            if (RemoteCommand.this.programOpts.isInteractive() && (cons = System.console()) != null) {
                String puser;
                String password;
                ProgramOptions.PasswordLocation pwloc = RemoteCommand.this.programOpts.getPasswordLocation();
                if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                    this.logger.fine(strings.get("BadPasswordFromFile", new Object[]{RemoteCommand.this.programOpts.getPasswordFile()}));
                } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                    try {
                        LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                        this.logger.fine(strings.get("BadPasswordFromLogin", new Object[]{store.getName()}));
                    }
                    catch (StoreException ex) {
                        // empty catch block
                    }
                }
                String user = null;
                if (RemoteCommand.this.programOpts.getUser() == null) {
                    cons.printf("%s ", strings.get("AdminUserPrompt"));
                    user = cons.readLine();
                    if (user == null) {
                        return false;
                    }
                }
                if ((password = RemoteCommand.ok(puser = RemoteCommand.ok(user) ? user : RemoteCommand.this.programOpts.getUser()) ? RemoteCommand.this.readPassword(strings.get("AdminUserPasswordPrompt", new Object[]{puser})) : RemoteCommand.this.readPassword(strings.get("AdminPasswordPrompt"))) == null) {
                    return false;
                }
                if (RemoteCommand.ok(user)) {
                    RemoteCommand.this.programOpts.setUser(user);
                    this.user = user;
                }
                RemoteCommand.this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
                this.password = password;
                return true;
            }
            return false;
        }

        protected String getFromEnvironment(String name) {
            return RemoteCommand.this.env.getStringOption(name);
        }

        protected boolean retryUsingSecureConnection(String host, int port) {
            String msg = strings.get("ServerMaybeSecure", new Object[]{host, port + ""});
            this.logger.info(msg);
            return true;
        }

        protected String reportAuthenticationException() {
            String msg = null;
            ProgramOptions.PasswordLocation pwloc = RemoteCommand.this.programOpts.getPasswordLocation();
            if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                msg = strings.get("InvalidCredentialsFromFile", new Object[]{RemoteCommand.this.programOpts.getUser(), RemoteCommand.this.programOpts.getPasswordFile()});
            } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                try {
                    LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                    msg = strings.get("InvalidCredentialsFromLogin", new Object[]{RemoteCommand.this.programOpts.getUser(), store.getName()});
                }
                catch (StoreException storeException) {
                    // empty catch block
                }
            }
            if (msg == null) {
                msg = strings.get("InvalidCredentials", new Object[]{RemoteCommand.this.programOpts.getUser()});
            }
            return msg;
        }
    }
}

