/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Resources
extends ConfigBeanProxy,
Injectable {
    @Element(value="*")
    public List<Resource> getResources();

    @DuckTyped
    public <T> Collection<T> getResources(Class<T> var1);

    @DuckTyped
    public <T> Resource getResourceByName(Class<T> var1, String var2);

    @DuckTyped
    public Collection<BindableResource> getResourcesOfPool(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static <T> Collection<T> getResources(Resources resources, Class<T> type) {
            ArrayList<T> filteredResources = new ArrayList<T>();
            for (Resource resource : resources.getResources()) {
                if (!type.isInstance(resource)) continue;
                filteredResources.add(type.cast(resource));
            }
            return filteredResources;
        }

        public static Collection<BindableResource> getResourcesOfPool(Resources resources, String connectionPoolName) {
            HashSet<BindableResource> resourcesReferringPool = new HashSet<BindableResource>();
            ResourcePool pool = (ResourcePool)resources.getResourceByName(ResourcePool.class, connectionPoolName);
            if (pool != null) {
                Collection<BindableResource> bindableResources = Duck.getResources(resources, BindableResource.class);
                for (BindableResource resource : bindableResources) {
                    if (ConnectorResource.class.isAssignableFrom(resource.getClass())) {
                        if (!((ConnectorResource)resource).getPoolName().equals(connectionPoolName)) continue;
                        resourcesReferringPool.add(resource);
                        continue;
                    }
                    if (!JdbcResource.class.isAssignableFrom(resource.getClass()) || !((JdbcResource)resource).getPoolName().equals(connectionPoolName)) continue;
                    resourcesReferringPool.add(resource);
                }
            }
            return resourcesReferringPool;
        }

        public static <T> Resource getResourceByName(Resources resources, Class<T> type, String name) {
            Class c;
            Object foundRes = null;
            boolean bindableResource = BindableResource.class.isAssignableFrom(type);
            boolean poolResource = ResourcePool.class.isAssignableFrom(type);
            boolean workSecurityMap = WorkSecurityMap.class.isAssignableFrom(type);
            boolean rac = ResourceAdapterConfig.class.isAssignableFrom(type);
            if (bindableResource) {
                c = BindableResource.class;
            } else if (poolResource) {
                c = ResourcePool.class;
            } else if (workSecurityMap) {
                c = WorkSecurityMap.class;
            } else if (rac) {
                c = ResourceAdapterConfig.class;
            } else {
                return null;
            }
            Collection<BindableResource> typedResources = resources.getResources(c);
            Iterator<BindableResource> itr = typedResources.iterator();
            while (itr.hasNext()) {
                String resourceName = null;
                Resource res = itr.next();
                if (bindableResource) {
                    resourceName = ((BindableResource)res).getJndiName();
                } else if (poolResource) {
                    resourceName = ((ResourcePool)res).getName();
                } else if (rac) {
                    resourceName = ((ResourceAdapterConfig)res).getResourceAdapterName();
                } else if (workSecurityMap) {
                    resourceName = ((WorkSecurityMap)res).getName();
                }
                if (!name.equals(resourceName)) continue;
                foundRes = res;
                break;
            }
            if (type != null && foundRes != null && type.isAssignableFrom(foundRes.getClass())) {
                return foundRes;
            }
            return null;
        }
    }
}

