/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.flashlight.cli.MonitoringConfig;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="enable-monitoring")
@Scoped(value=PerLookup.class)
@I18n(value="enable.monitoring")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class EnableMonitoring
implements AdminCommand {
    private MonitoringService ms;
    @Inject
    private Target targetService;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(optional=true)
    private String pid;
    @Param(optional=true)
    private String options;
    @Param(optional=true)
    private String modules;
    @Param(optional=true)
    private Boolean mbean;
    @Param(optional=true)
    private Boolean dtrace;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableMonitoring.class);
    static final String FLASHLIGHT_AGENT_PATH = "lib/monitor/flashlight-agent.jar";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.ms = this.targetService.getConfig(this.target).getMonitoringService();
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("target.service.exception", "Encountered exception trying to locate the MonitoringService element in the target ({0}) configuration: {1}", new Object[]{this.target, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!FlashlightProbeClientMediator.isAgentAttached()) {
            if (!this.isValidString(this.pid)) {
                int i = ProcessUtils.getPid();
                if (i == -1) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "invalid pid, pl. provide the application server's pid using --pid option, you may get pid using jps command"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                } else {
                    this.pid = String.valueOf(i);
                }
            }
            if (this.isValidString(this.pid)) {
                FlashlightProbeClientMediator.setAgentInitialized(false);
                this.attachAgent(report);
            }
        }
        if (this.modules != null && this.modules.length() > 0) {
            String[] strArr = this.modules.split(":");
            String[] nvArr = null;
            for (String nv : strArr) {
                if (nv.length() <= 0) continue;
                nvArr = nv.split("=");
                if (nvArr.length > 1) {
                    if (!this.isValidString(nvArr[1])) continue;
                    this.setModuleMonitoringLevel(nvArr[0], nvArr[1], report);
                    continue;
                }
                if (!this.isValidString(nvArr[0])) continue;
                this.setModuleMonitoringLevel(nvArr[0], "HIGH", report);
            }
        }
        if (this.mbean != null) {
            MonitoringConfig.setMBeanEnabled(this.ms, this.mbean.toString(), report);
        }
        if (this.dtrace != null) {
            MonitoringConfig.setDTraceEnabled(this.ms, this.dtrace.toString(), report);
        }
        MonitoringConfig.setMonitoringEnabled(this.ms, "true", report);
    }

    private void attachAgent(ActionReport report) {
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        try {
            VirtualMachine vm = VirtualMachine.attach(this.pid);
            File installDir = new File(System.getProperty("com.sun.aas.installRoot"));
            File agentJar = this.getAgentJar(installDir);
            if (agentJar.isFile()) {
                if (this.options == null) {
                    vm.loadAgent(agentJar.getPath());
                } else {
                    vm.loadAgent(agentJar.getPath(), this.options);
                }
                part.setMessage(this.localStrings.getLocalString("attach.agent.suucess", "flashlight agent attached"));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "flashlight-agent.jar does not exist under {0}", new Object[]{agentJar}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        catch (Exception e) {
            part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "Encountered exception during agent attach {0}", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void setModuleMonitoringLevel(String moduleName, String level, ActionReport report) {
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        if (!this.isValidString(moduleName)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid module name {0}", new Object[]{moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (!this.isValidString(level) || !this.isValidLevel(level)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid level {0} for module name {1}", new Object[]{level, moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        MonitoringConfig.setMonitoringLevel(this.ms, moduleName, level, report);
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    private boolean isValidLevel(String level) {
        return level.equals("OFF") || level.equals("HIGH") || level.equals("LOW");
    }

    private File getAgentJar(File installDir) {
        return new File(installDir, FLASHLIGHT_AGENT_PATH);
    }
}

