/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class EmbeddedOSGiGlassFishRuntime
extends GlassFishRuntime {
    List<GlassFish> gfs = new ArrayList<GlassFish>();

    public synchronized GlassFish newGlassFish(GlassFishProperties gfProps) throws GlassFishException {
        try {
            this.setEnv(gfProps.getProperties());
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ServiceTracker hk2Tracker = new ServiceTracker(this.getBundleContext(), Main.class.getName(), null);
            hk2Tracker.open();
            Main main = (Main)hk2Tracker.waitForService(0L);
            hk2Tracker.close();
            ModulesRegistry mr = (ModulesRegistry)ModulesRegistry.class.cast(this.getBundleContext().getService(this.getBundleContext().getServiceReference(ModulesRegistry.class.getName())));
            Habitat habitat = main.createHabitat(mr, startupContext);
            ModuleStartup gfKernel = main.findStartupService(mr, habitat, null, startupContext);
            GlassFish glassFish = this.createGlassFish(gfKernel, habitat, gfProps.getProperties());
            this.gfs.add(glassFish);
            this.getBundleContext().registerService(GlassFish.class.getName(), (Object)glassFish, (Dictionary)gfProps.getProperties());
            return glassFish;
        }
        catch (BootException ex) {
            throw new GlassFishException(ex);
        }
        catch (InterruptedException ex) {
            throw new GlassFishException(ex);
        }
    }

    public synchronized void shutdown() throws GlassFishException {
        for (GlassFish gf : this.gfs) {
            if (gf.getStatus() == GlassFish.Status.DISPOSED) continue;
            try {
                gf.dispose();
            }
            catch (GlassFishException e) {
                e.printStackTrace();
            }
        }
        this.gfs.clear();
        EmbeddedOSGiGlassFishRuntime.shutdownInternal();
        System.out.println("Completed shutdown of GlassFish runtime");
    }

    private void setEnv(Properties properties) {
        String instanceRootValue;
        String installRootValue = properties.getProperty("com.sun.aas.installRoot");
        if (installRootValue != null && !installRootValue.isEmpty()) {
            File installRoot = new File(installRootValue);
            System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            Properties asenv = ASMainHelper.parseAsEnv(installRoot);
            for (String s : asenv.stringPropertyNames()) {
                System.setProperty(s, asenv.getProperty(s));
            }
            System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if ((instanceRootValue = properties.getProperty("com.sun.aas.instanceRoot")) != null && !instanceRootValue.isEmpty()) {
            File instanceRoot = new File(instanceRootValue);
            System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
    }

    protected GlassFish createGlassFish(ModuleStartup gfKernel, Habitat habitat, Properties gfProps) throws GlassFishException {
        return new GlassFishImpl(gfKernel, habitat, gfProps);
    }

    public BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }
}

