/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.framework.Bundle;

class Jar {
    private URI uri;
    private long lastModified = -1L;
    private long bundleId = -1L;

    Jar(File file) {
        this.uri = file.toURI().normalize();
        this.lastModified = file.lastModified();
    }

    Jar(Bundle b) throws URISyntaxException {
        String location = b.getLocation();
        if (location != null && !location.equals("System Bundle")) {
            this.uri = new URI(b.getLocation()).normalize();
        }
        this.lastModified = b.getLastModified();
        this.bundleId = b.getBundleId();
    }

    public Jar(URI uri) {
        this.uri = uri.normalize();
        try {
            File f = new File(uri);
            this.lastModified = f.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getPath() {
        return this.uri == null ? null : this.uri.getPath();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public boolean isNewer(Jar other) {
        return this.getLastModified() > other.getLastModified();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jar) {
            return this.uri.toString().equals(((Jar)obj).uri.toString());
        }
        return false;
    }
}

