/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import java.io.File;
import java.util.Properties;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class AutoDeploymentOperation
extends AutoOperation {
    private boolean renameOnSuccess;
    private static final String COMMAND_NAME = "deploy";
    @Inject(name="deploy")
    private AdminCommand deployCommand;
    @Inject
    private AutodeployRetryManager retryManager;

    static AutoDeploymentOperation newInstance(Habitat habitat, boolean renameOnSuccess, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target) {
        AutoDeploymentOperation o = (AutoDeploymentOperation)habitat.getComponent(AutoDeploymentOperation.class);
        o.init(renameOnSuccess, file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target);
        return o;
    }

    protected AutoDeploymentOperation init(boolean renameOnSuccess, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target) {
        super.init(file, AutoDeploymentOperation.getDeployActionProperties(file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target), COMMAND_NAME, this.deployCommand);
        this.renameOnSuccess = renameOnSuccess;
        return this;
    }

    protected String getMessageString(AutoDeployer.AutodeploymentStatus ds, File file) {
        return localStrings.getLocalString(ds.deploymentMessageKey, ds.deploymentDefaultMessage, new Object[]{file});
    }

    protected void markFiles(AutoDeployer.AutodeploymentStatus ds, File file) {
        if (ds != AutoDeployer.AutodeploymentStatus.SUCCESS) {
            try {
                this.retryManager.recordFailedDeployment(file);
            }
            catch (AutoDeploymentException ex) {
                this.markDeployFailed(file);
                this.retryManager.endMonitoring(file);
            }
        } else {
            this.retryManager.recordSuccessfulDeployment(file);
            if (ds.status) {
                if (this.renameOnSuccess) {
                    this.markDeployed(file);
                }
            } else {
                this.markDeployFailed(file);
            }
        }
    }

    private void markDeployed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getDeployedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markDeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getDeployFailedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Properties getDeployActionProperties(File deployablefile, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean jspPreCompilation, String target) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setPath(deployablefile.getAbsolutePath());
        dProps.setEnabled(enabled);
        if (virtualServer != null) {
            dProps.setVirtualServers(virtualServer);
        }
        dProps.setForce(forceDeploy);
        dProps.setVerify(verify);
        dProps.setPrecompileJSP(jspPreCompilation);
        dProps.setProperty("logReportedErrors", "false");
        return dProps;
    }
}

