/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.grizzly.Context;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.ssl.SSLSelectorThreadHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class MonitorableSSLSelectorHandler
extends SSLSelectorThreadHandler {
    private GrizzlyMonitoring grizzlyMonitoring;
    private String monitoringId;

    public MonitorableSSLSelectorHandler(GrizzlyMonitoring grizzlyMonitoring, String monitoringId) {
        this(grizzlyMonitoring, monitoringId, null);
    }

    public MonitorableSSLSelectorHandler(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, SelectorThread selectorThread) {
        super(selectorThread);
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        MonitorableSSLSelectorHandler copyHandler = (MonitorableSSLSelectorHandler)copy;
        copyHandler.grizzlyMonitoring = this.grizzlyMonitoring;
        copyHandler.monitoringId = this.monitoringId;
    }

    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)super.acceptWithoutRegistration(key);
        if (channel != null) {
            String address = ((InetSocketAddress)channel.socket().getRemoteSocketAddress()).toString();
            this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionAcceptedEvent(this.monitoringId, channel.hashCode(), address);
        }
        return channel;
    }

    public boolean onConnectInterest(SelectionKey key, Context ctx) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        String address = ((InetSocketAddress)channel.socket().getRemoteSocketAddress()).toString();
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionConnectedEvent(this.monitoringId, channel.hashCode(), address);
        return super.onConnectInterest(key, ctx);
    }
}

