/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.DiagnosticService;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.SessionManager;
import com.sun.enterprise.config.serverbeans.StoreProperties;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="defaultconfigupgrade")
public class DefaultConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    private static final String DEFAULT_CONFIG = "default-config";
    private static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DefaultConfigUpgrade.class);
    private XMLStreamReader parser;
    private InputStreamReader reader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        Config defaultConfig = this.configs.getConfigByName(DEFAULT_CONFIG);
        if (defaultConfig != null) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.INFO, localStrings.getLocalString("DefaultConfigUpgrade.existingDefaultConfig", "Existing default-config detected during upgrade. No need to create default-config."));
            return;
        }
        String installRoot = System.getProperty(INSTALL_ROOT);
        if (installRoot == null) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.INFO, localStrings.getLocalString("DefaultConfigUpgrade.installRootIsNull", "System Property com.sun.aas.installRoot is null. We could be running in unit tests.Exiting DefaultConfigUpgrade"));
            return;
        }
        Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.INFO, localStrings.getLocalString("DefaultConfigUpgrade.runningDefaultConfigUpgrade", "default-config not detected during upgrade. Running DefaultConfigUpgrade to create default-config."));
        String template = this.getDomainXmlTemplate();
        try {
            ConfigSupport.apply((SingleConfigCode)new MinDefaultConfigCode(), (ConfigBeanProxy)this.configs);
            defaultConfig = this.configs.getConfigByName(DEFAULT_CONFIG);
            this.createParser(template);
            this.createDefaultConfigAttr(defaultConfig);
            this.createHttpServiceConfig(defaultConfig);
            this.createIiopServiceConfig(defaultConfig);
            this.createAdminServiceConfig(defaultConfig);
            this.createWebContainerConfig(defaultConfig);
            this.createEjbContainerConfig(defaultConfig);
            this.createJmsServiceConfig(defaultConfig);
            this.createLogServiceConfig(defaultConfig);
            this.createSecurityServiceConfig(defaultConfig);
            this.createTransactionServiceConfig(defaultConfig);
            this.createDiagnosticServiceConfig(defaultConfig);
            this.createJavaConfig(defaultConfig);
            this.createAvailabilityService(defaultConfig);
            this.createNetworkConfig(defaultConfig);
            this.createThreadPools(defaultConfig);
            this.createManagementRules(defaultConfig);
            this.createSystemProperties(defaultConfig);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, localStrings.getLocalString("DefaultConfigUpgrade.failure", "Failure during upgrade - could not create default-config"), ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, localStrings.getLocalString("DefaultConfigUpgrade.failure", "Failure during upgrade - could not create default-config"), ex);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, localStrings.getLocalString("DefaultConfigUpgrade.failure", "Failure during upgrade - could not create default-config"), ex);
        }
        finally {
            try {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private String getDomainXmlTemplate() {
        String installRoot = System.getProperty(INSTALL_ROOT);
        String template = installRoot + File.separator + "lib" + File.separator + "templates" + File.separator + "domain.xml";
        File f = new File(template);
        if (!f.exists()) {
            throw new RuntimeException(localStrings.getLocalString("DefaultConfigUpgrade.missingDomainXmlTemplate", "DefaultConfigUpgrade failed. Missing domain.xml template here " + template, new Object[]{template}));
        }
        Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.INFO, localStrings.getLocalString("DefaultConfigUpgrade.foundDomainXmlTemaplate", "Found domain.xml template to create default-config: " + template, new Object[]{template}));
        return template;
    }

    private void createDefaultConfigAttr(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("config") || !this.parser.getAttributeValue(null, "name").equals(DEFAULT_CONFIG)) {
        }
        ConfigSupport.apply((SingleConfigCode)new DefaultConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createHttpServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("http-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new HttpServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createIiopServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("iiop-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new IiopServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createAdminServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("admin-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new AdminServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createWebContainerConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("web-container")) {
        }
        SessionManager sm = defaultConfig.getWebContainer().getSessionConfig().getSessionManager();
        ConfigSupport.apply((SingleConfigCode)new WebContainerConfigCode(), (ConfigBeanProxy)sm);
    }

    private void createEjbContainerConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("ejb-container")) {
        }
        ConfigSupport.apply((SingleConfigCode)new EjbContainerConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createJmsServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("jms-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new JmsServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createLogServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("log-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new LogServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createSecurityServiceConfig(Config defaultConfig) {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("security-service")) {
                }
                ConfigSupport.apply((SingleConfigCode)new SecurityServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating SecurityService Config", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing security-service", ex);
                continue;
            }
            break;
        }
    }

    private void createTransactionServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("transaction-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new TransactionServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createDiagnosticServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("diagnostic-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new DiagnosticServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createJavaConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("java-config")) {
        }
        ConfigSupport.apply((SingleConfigCode)new JavaConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createAvailabilityService(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("availability-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new AvailabilityServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createNetworkConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-config")) {
        }
        ConfigSupport.apply((SingleConfigCode)new NetworkConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createThreadPools(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("thread-pools")) {
        }
        ConfigSupport.apply((SingleConfigCode)new ThreadPoolsConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createManagementRules(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        ConfigSupport.apply((SingleConfigCode)new ManagementRulesConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createSystemProperties(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        ConfigSupport.apply((SingleConfigCode)new SystemPropertyConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createVirtualServer(HttpService hs) throws PropertyVetoException {
        try {
            while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("http-service")) {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("virtual-server")) continue;
                VirtualServer vs = (VirtualServer)hs.createChild(VirtualServer.class);
                hs.getVirtualServer().add(vs);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    if (attr.equals("id")) {
                        vs.setId(this.parser.getAttributeValue(i));
                    }
                    if (!attr.equals("network-listeners")) continue;
                    vs.setNetworkListeners(this.parser.getAttributeValue(i));
                }
                this.createVirtualServerProperty(vs);
            }
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failed to create HttpService VirtualService config object", ex);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing http-service virtual-server in domain.xml template", ex);
        }
    }

    private void createVirtualServerProperty(VirtualServer vs) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("virtual-server")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property")) continue;
                Property p = (Property)vs.createChild(Property.class);
                vs.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failed creating VirtualServer Property config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing virtual-server property element in domain.xml template", ex);
            }
        }
    }

    private void createOrb(IiopService is) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("orb")) {
                }
                Orb orb = (Orb)is.createChild(Orb.class);
                is.setOrb(orb);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    if (!attr.equals("use-thread-pool-ids")) continue;
                    orb.setUseThreadPoolIds(this.parser.getAttributeValue(i));
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating IiopService Orb config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing iiop-service orb element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createIiopListener(IiopService is) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("iiop-service")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("iiop-listener")) continue;
                IiopListener il = (IiopListener)is.createChild(IiopListener.class);
                is.getIiopListener().add(il);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    if (attr.equals("port")) {
                        il.setPort(this.parser.getAttributeValue(i));
                    }
                    if (attr.equals("id")) {
                        il.setId(this.parser.getAttributeValue(i));
                    }
                    if (attr.equals("address")) {
                        il.setAddress(this.parser.getAttributeValue(i));
                    }
                    if (!attr.equals("security-enabled")) continue;
                    il.setSecurityEnabled(this.parser.getAttributeValue(i));
                }
                this.createIiopListenerSsl(il);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating IiopService IiopListener config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing iiop-service iiop-listener element in domain.xml template", ex);
            }
        }
    }

    private void createIiopListenerSsl(IiopListener il) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("iiop-listener")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("ssl") || il == null) continue;
                Ssl ssl = (Ssl)il.createChild(Ssl.class);
                il.setSsl(ssl);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    if (attr.equals("classname")) {
                        ssl.setClassname(this.parser.getAttributeValue(i));
                    }
                    if (attr.equals("cert-nickname")) {
                        ssl.setCertNickname(this.parser.getAttributeValue(i));
                    }
                    if (!attr.equals("client-auth-enabled")) continue;
                    ssl.setClientAuthEnabled(this.parser.getAttributeValue(i));
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failed to create IiopListener Ssl config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing iiop-listner ssl element in domain.xml template", ex);
            }
        }
    }

    private void createJmxConnector(AdminService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("jmx-connector")) {
                }
                JmxConnector jc = (JmxConnector)as.createChild(JmxConnector.class);
                as.getJmxConnector().add(jc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("address")) {
                        jc.setAddress(val);
                    }
                    if (attr.equals("auth-realm-name")) {
                        jc.setAuthRealmName(val);
                    }
                    if (attr.equals("name")) {
                        jc.setName(val);
                    }
                    if (attr.equals("port")) {
                        jc.setPort(val);
                    }
                    if (attr.equals("protocol")) {
                        jc.setProtocol(val);
                    }
                    if (!attr.equals("security-enabled")) continue;
                    jc.setSecurityEnabled(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failed to create AdminService JmxConnector config object.", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing admin-service jmx-connector", ex);
                continue;
            }
            break;
        }
    }

    private void createAdminServiceProperty(AdminService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("property")) {
                }
                Property p = (Property)as.createChild(Property.class);
                as.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failed to create AdminService Property config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing asadmin-service property element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createJmsHost(JmsService js) throws PropertyVetoException {
        try {
            while (this.parser.next() != 1 || !this.parser.getLocalName().equals("jms-host") || js == null) {
            }
            JmsHost jh = (JmsHost)js.createChild(JmsHost.class);
            js.getJmsHost().add(jh);
            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                String attr = this.parser.getAttributeLocalName(i);
                String val = this.parser.getAttributeValue(i);
                if (attr.equals("name")) {
                    jh.setName(val);
                }
                if (attr.equals("host")) {
                    jh.setHost(val);
                }
                if (attr.equals("port")) {
                    jh.setPort(val);
                }
                if (attr.equals("admin-user-name")) {
                    jh.setAdminUserName(val);
                }
                if (attr.equals("admin-password")) {
                    jh.setAdminPassword(val);
                }
                if (!attr.equals("lazy-init")) continue;
                jh.setLazyInit(val);
            }
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating JmsHost config object", ex);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jms-host element in domain.xml template", ex);
        }
    }

    private void createModuleLogLevels(LogService ls) throws PropertyVetoException {
        try {
            while (this.parser.next() != 1 || !this.parser.getLocalName().equals("module-log-levels") || ls == null) {
            }
            ModuleLogLevels mll = (ModuleLogLevels)ls.createChild(ModuleLogLevels.class);
            ls.setModuleLogLevels(mll);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating ModuleLogLevel config object", ex);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing module-log-levels in domain.xml template", ex);
        }
    }

    private void createAuthRealm(SecurityService ss) throws PropertyVetoException {
        while (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("jacc-provider")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("auth-realm") || ss == null) continue;
                AuthRealm ar = (AuthRealm)ss.createChild(AuthRealm.class);
                ss.getAuthRealm().add(ar);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        ar.setClassname(val);
                    }
                    if (!attr.equals("name")) continue;
                    ar.setName(val);
                }
                this.createAuthRealmProperty(ar);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating AuthRealm", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing auth-realm", ex);
            }
        }
    }

    private void createAuthRealmProperty(AuthRealm ar) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("auth-realm")) {
            String attr = null;
            String val = null;
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || ar == null) continue;
                Property p = (Property)ar.createChild(Property.class);
                ar.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create AuthRealm Property failed. Attr = " + attr + " Val = " + val, ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing auth-realm property", ex);
            }
        }
    }

    private void createJaccProvider(SecurityService ss) throws PropertyVetoException {
        while (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("audit-module")) {
            try {
                if (this.parser.getEventType() != 1 && this.parser.next() != 1 || !this.parser.getLocalName().equals("jacc-provider") || ss == null) continue;
                JaccProvider jp = (JaccProvider)ss.createChild(JaccProvider.class);
                ss.getJaccProvider().add(jp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("policy-provider")) {
                        jp.setPolicyProvider(val);
                    }
                    if (attr.equals("name")) {
                        jp.setName(val);
                    }
                    if (!attr.equals("policy-configuration-factory-provider")) continue;
                    jp.setPolicyConfigurationFactoryProvider(val);
                }
                this.createJaccProviderProperty(jp);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating JaccProvider", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jacc-provider", ex);
            }
        }
    }

    private void createJaccProviderProperty(JaccProvider jp) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("jacc-provider")) {
            String attr = null;
            String val = null;
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || jp == null) continue;
                Property p = (Property)jp.createChild(Property.class);
                jp.getProperty().add(p);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    attr = this.parser.getAttributeLocalName(i);
                    val = this.parser.getAttributeValue(i);
                    if (attr.equals("name")) {
                        p.setName(val);
                    }
                    if (!attr.equals("value")) continue;
                    p.setValue(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create JaccProvider Property failed. Attr = " + attr + " Val = " + val, ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jacc-provider property", ex);
            }
        }
    }

    private void createAuditModule(SecurityService ss) throws PropertyVetoException {
        try {
            if (this.parser.getLocalName().equals("audit-module") && ss != null) {
                AuditModule am = (AuditModule)ss.createChild(AuditModule.class);
                ss.getAuditModule().add(am);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        am.setClassname(val);
                    }
                    if (!attr.equals("name")) continue;
                    am.setName(val);
                }
                this.createAuditModuleProperty(am);
            }
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating AuditModule config object", ex);
        }
    }

    private void createAuditModuleProperty(AuditModule am) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("audit-module")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || am == null) continue;
                Property p = (Property)am.createChild(Property.class);
                am.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create JaccProvider Property failed.", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jacc-provider property", ex);
            }
        }
    }

    private void createMessageSecurityConfig(SecurityService ss) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("message-security-config") || ss == null) {
                }
                MessageSecurityConfig msc = (MessageSecurityConfig)ss.createChild(MessageSecurityConfig.class);
                ss.getMessageSecurityConfig().add(msc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-layer")) continue;
                    msc.setAuthLayer(val);
                }
                this.createProviderConfig(msc);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating JaccProvider", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jacc-provider", ex);
                continue;
            }
            break;
        }
    }

    private void createProviderConfig(MessageSecurityConfig msc) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("message-security-config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("provider-config") || msc == null) continue;
                ProviderConfig pc = (ProviderConfig)msc.createChild(ProviderConfig.class);
                msc.getProviderConfig().add(pc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("provider-type")) {
                        pc.setProviderType(val);
                    }
                    if (attr.equals("provider-id")) {
                        pc.setProviderId(val);
                    }
                    if (!attr.equals("class-name")) continue;
                    pc.setClassName(val);
                }
                this.createRequestPolicy(pc);
                this.createResponsePolicy(pc);
                this.createProviderConfigProperty(pc);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating ProviderConfig", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing provider-config", ex);
            }
        }
    }

    private void createRequestPolicy(ProviderConfig pc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("request-policy") || pc == null) {
                }
                RequestPolicy rp = (RequestPolicy)pc.createChild(RequestPolicy.class);
                pc.setRequestPolicy(rp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-source")) continue;
                    rp.setAuthSource(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create ProviderConfig RequestPolicy failed.", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing request-policy property", ex);
                continue;
            }
            break;
        }
    }

    private void createResponsePolicy(ProviderConfig pc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("response-policy") || pc == null) {
                }
                ResponsePolicy rp = (ResponsePolicy)pc.createChild(ResponsePolicy.class);
                pc.setResponsePolicy(rp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-source")) continue;
                    rp.setAuthSource(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create ProviderConfig RequestPolicy failed.", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing request-policy property", ex);
                continue;
            }
            break;
        }
    }

    private void createProviderConfigProperty(ProviderConfig pc) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("provider-config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || pc == null) continue;
                Property p = (Property)pc.createChild(Property.class);
                pc.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Create ProviderConfig Property failed", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing provider-config property", ex);
            }
        }
    }

    private void createJvmOptions(JavaConfig jc) {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("java-config")) {
            try {
                int eventType = this.parser.next();
                if (eventType != 1 || !this.parser.getLocalName().equals("jvm-options") || jc == null) continue;
                jc.getJvmOptions().add(this.parser.getElementText());
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jvm-options", ex);
            }
        }
    }

    private void createWebContainerAvailability(AvailabilityService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("web-container-availability") || as == null) {
                }
                WebContainerAvailability wca = (WebContainerAvailability)as.createChild(WebContainerAvailability.class);
                as.setWebContainerAvailability(wca);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("availability-enabled")) {
                        wca.setAvailabilityEnabled(val);
                    }
                    if (attr.equals("persistence-frequency")) {
                        wca.setPersistenceFrequency(val);
                    }
                    if (!attr.equals("persistence-scope")) continue;
                    wca.setPersistenceScope(val);
                }
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing web-container-availability element in domain.xml", ex);
                continue;
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating WebContainerAvailability config object", ex);
                continue;
            }
            break;
        }
    }

    private void createEjbContainerAvailability(AvailabilityService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("ejb-container-availability") || as == null) {
                }
                EjbContainerAvailability eca = (EjbContainerAvailability)as.createChild(EjbContainerAvailability.class);
                as.setEjbContainerAvailability(eca);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("availability-enabled")) {
                        eca.setAvailabilityEnabled(val);
                    }
                    if (!attr.equals("sfsb-store-pool-name")) continue;
                    eca.setSfsbStorePoolName(val);
                }
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing ejb-container-availability element in domain.xml template", ex);
                continue;
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating EjbContainerAvailability config object", ex);
                continue;
            }
            break;
        }
    }

    private void createJmsAvailability(AvailabilityService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("jms-availability") || as == null) {
                }
                JmsAvailability ja = (JmsAvailability)as.createChild(JmsAvailability.class);
                as.setJmsAvailability(ja);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("availability-enabled")) continue;
                    ja.setAvailabilityEnabled(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating JmsAvailability config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing jms-availability element in domain.xml", ex);
                continue;
            }
            break;
        }
    }

    private void createProtocols(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("protocols") || nc == null) {
                }
                Protocols ps = (Protocols)nc.createChild(Protocols.class);
                nc.setProtocols(ps);
                this.createProtocol(ps);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Protocols config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing protocols element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createProtocol(Protocols ps) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("protocols")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("protocol") || ps == null) continue;
                Protocol p = (Protocol)ps.createChild(Protocol.class);
                ps.getProtocol().add(p);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("security-enabled")) {
                        p.setSecurityEnabled(val);
                    }
                    if (!attr.equals("name")) continue;
                    p.setName(val);
                }
                this.createHttp(p);
                this.createSsl(p);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Protocol config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing protocol element in domain.xml template", ex);
            }
        }
    }

    private void createHttp(Protocol p) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("http") || p == null) {
                }
                Http h = (Http)p.createChild(Http.class);
                p.setHttp(h);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("default-virtual-server")) {
                        h.setDefaultVirtualServer(val);
                    }
                    if (!attr.equals("max-connections")) continue;
                    h.setMaxConnections(val);
                }
                this.createFileCache(h);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Http config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing http element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createFileCache(Http h) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("file-cache") || h == null) {
                }
                FileCache fc = (FileCache)h.createChild(FileCache.class);
                h.setFileCache(fc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("enabled")) continue;
                    fc.setEnabled(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating FileCache config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing file-cache element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createSsl(Protocol p) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("protocol")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("ssl") || p == null) continue;
                Ssl ssl = (Ssl)p.createChild(Ssl.class);
                p.setSsl(ssl);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        ssl.setClassname(val);
                    }
                    if (attr.equals("ssl3-enabled")) {
                        ssl.setSsl3Enabled(val);
                    }
                    if (!attr.equals("cert-nickname")) continue;
                    ssl.setCertNickname(val);
                }
                break;
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Ssl config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing ssl element in domain.xml template", ex);
            }
        }
    }

    private void createNetworkListeners(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-listeners") || nc == null) {
                }
                NetworkListeners nls = (NetworkListeners)nc.createChild(NetworkListeners.class);
                nc.setNetworkListeners(nls);
                this.createNetworkListener(nls);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating NetworkListeners config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing network-listeners element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createNetworkListener(NetworkListeners nls) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("network-listeners")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-listener") || nls == null) continue;
                NetworkListener nl = (NetworkListener)nls.createChild(NetworkListener.class);
                nls.getNetworkListener().add(nl);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("address")) {
                        nl.setAddress(val);
                    }
                    if (attr.equals("port")) {
                        nl.setPort(val);
                    }
                    if (attr.equals("protocol")) {
                        nl.setProtocol(val);
                    }
                    if (attr.equals("transport")) {
                        nl.setTransport(val);
                    }
                    if (attr.equals("name")) {
                        nl.setName(val);
                    }
                    if (!attr.equals("thread-pool")) continue;
                    nl.setThreadPool(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating NetworkListener config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing network-listener element in domain.xml template", ex);
            }
        }
    }

    private void createTransports(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("transports") || nc == null) {
                }
                Transports ts = (Transports)nc.createChild(Transports.class);
                nc.setTransports(ts);
                this.createTransport(ts);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Transports config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing transports element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createTransport(Transports ts) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("transport") || ts == null) {
                }
                Transport t = (Transport)ts.createChild(Transport.class);
                ts.getTransport().add(t);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("name")) continue;
                    t.setName(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating Transport config object", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing transport element in domain.xml template", ex);
                continue;
            }
            break;
        }
    }

    private void createThreadPool(ThreadPools ts) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("thread-pools")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("thread-pool") || ts == null) continue;
                ThreadPool t = (ThreadPool)ts.createChild(ThreadPool.class);
                ts.getThreadPool().add(t);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("max-thread-pool-size")) {
                        t.setMaxThreadPoolSize(val);
                    }
                    if (attr.equals("idle-thread-timeout-in-seconds")) {
                        t.setIdleThreadTimeoutSeconds(val);
                    }
                    if (!attr.equals("name")) continue;
                    t.setName(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating ThreadPool config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing thread-pool element in domain.xml template", ex);
            }
        }
    }

    private void createSystemProperty(Config defaultConfig) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("system-property") || defaultConfig == null) continue;
                SystemProperty sp = (SystemProperty)defaultConfig.createChild(SystemProperty.class);
                defaultConfig.getSystemProperty().add(sp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("name")) {
                        sp.setName(val);
                    }
                    if (!attr.equals("value")) continue;
                    sp.setValue(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating SystemProperty config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing system-property element in domain.xml template", ex);
            }
        }
    }

    private void createProperty(Property p) throws PropertyVetoException {
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attr = this.parser.getAttributeLocalName(i);
            String val = this.parser.getAttributeValue(i);
            if (attr.equals("name")) {
                p.setName(val);
            }
            if (!attr.equals("value")) continue;
            p.setValue(val);
        }
    }

    private void createParser(String template) throws FileNotFoundException, XMLStreamException {
        if (template != null) {
            this.reader = new InputStreamReader(new FileInputStream(template));
            this.parser = XMLInputFactory.newInstance().createXMLStreamReader(template, this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SystemPropertyConfigCode
    implements SingleConfigCode<Config> {
        private SystemPropertyConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            DefaultConfigUpgrade.this.createSystemProperty(config);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagementRulesConfigCode
    implements SingleConfigCode<Config> {
        private ManagementRulesConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                ManagementRules mr = (ManagementRules)config.createChild(ManagementRules.class);
                config.setManagementRules(mr);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating ManagementRules config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadPoolsConfigCode
    implements SingleConfigCode<Config> {
        private ThreadPoolsConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                ThreadPools tps = (ThreadPools)config.createChild(ThreadPools.class);
                config.setThreadPools(tps);
                DefaultConfigUpgrade.this.createThreadPool(tps);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure to create ThreadPools config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetworkConfigCode
    implements SingleConfigCode<Config> {
        private NetworkConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                NetworkConfig nc = (NetworkConfig)config.createChild(NetworkConfig.class);
                config.setNetworkConfig(nc);
                DefaultConfigUpgrade.this.createProtocols(nc);
                DefaultConfigUpgrade.this.createNetworkListeners(nc);
                DefaultConfigUpgrade.this.createTransports(nc);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating NetworkConfig config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AvailabilityServiceConfigCode
    implements SingleConfigCode<Config> {
        private AvailabilityServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                AvailabilityService as = (AvailabilityService)config.createChild(AvailabilityService.class);
                config.setAvailabilityService(as);
                DefaultConfigUpgrade.this.createWebContainerAvailability(as);
                DefaultConfigUpgrade.this.createEjbContainerAvailability(as);
                DefaultConfigUpgrade.this.createJmsAvailability(as);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating AvailabilityService config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaConfigCode
    implements SingleConfigCode<Config> {
        private JavaConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                JavaConfig jc = (JavaConfig)config.createChild(JavaConfig.class);
                config.setJavaConfig(jc);
                for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                    String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                    String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                    if (attr.equals("debug-options")) {
                        jc.setDebugOptions(val);
                    }
                    if (attr.equals("system-classpath")) {
                        jc.setSystemClasspath(val);
                    }
                    if (!attr.equals("classpath-suffix")) continue;
                    jc.setClasspathSuffix(val);
                }
                DefaultConfigUpgrade.this.createJvmOptions(jc);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating JavaConfig config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiagnosticServiceConfigCode
    implements SingleConfigCode<Config> {
        private DiagnosticServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            DiagnosticService ds = (DiagnosticService)config.createChild(DiagnosticService.class);
            config.setDiagnosticService(ds);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransactionServiceConfigCode
    implements SingleConfigCode<Config> {
        private TransactionServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                TransactionService ts = (TransactionService)config.createChild(TransactionService.class);
                config.setTransactionService(ts);
                for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                    String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                    String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                    if (attr.equals("tx-log-dir")) {
                        ts.setTxLogDir(val);
                    }
                    if (!attr.equals("automatic-recovery")) continue;
                    ts.setAutomaticRecovery(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure create TransactionService config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SecurityServiceConfigCode
    implements SingleConfigCode<Config> {
        private SecurityServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                SecurityService ss = (SecurityService)config.createChild(SecurityService.class);
                config.setSecurityService(ss);
                DefaultConfigUpgrade.this.createAuthRealm(ss);
                DefaultConfigUpgrade.this.createJaccProvider(ss);
                DefaultConfigUpgrade.this.createAuditModule(ss);
                DefaultConfigUpgrade.this.createMessageSecurityConfig(ss);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating SecurityService config object", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogServiceConfigCode
    implements SingleConfigCode<Config> {
        private LogServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            LogService ls = null;
            try {
                ls = (LogService)config.createChild(LogService.class);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating LogService config object", ex);
            }
            config.setLogService(ls);
            for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                if (attr.equals("log-rotation-limit-in-bytes")) {
                    ls.setLogRotationLimitInBytes(val);
                }
                if (!attr.equals("file")) continue;
                ls.setFile(val);
            }
            DefaultConfigUpgrade.this.createModuleLogLevels(ls);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JmsServiceConfigCode
    implements SingleConfigCode<Config> {
        private JmsServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            JmsService js = (JmsService)config.createChild(JmsService.class);
            config.setJmsService(js);
            for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                if (attr.equals("type")) {
                    js.setType(val);
                }
                if (attr.equals("default-jms-host")) {
                    js.setDefaultJmsHost(val);
                }
                if (!attr.equals("addresslist-behavior")) continue;
                js.setAddresslistBehavior(val);
            }
            DefaultConfigUpgrade.this.createJmsHost(js);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EjbContainerConfigCode
    implements SingleConfigCode<Config> {
        private EjbContainerConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                EjbContainer ec = (EjbContainer)config.createChild(EjbContainer.class);
                config.setEjbContainer(ec);
                EjbTimerService ets = (EjbTimerService)ec.createChild(EjbTimerService.class);
                ec.setEjbTimerService(ets);
                for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                    String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                    String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                    if (!attr.equals("session-store")) continue;
                    ec.setSessionStore(val);
                }
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating EjbContainer EjbTimerService config objects", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebContainerConfigCode
    implements SingleConfigCode<SessionManager> {
        private WebContainerConfigCode() {
        }

        public Object run(SessionManager sm) throws PropertyVetoException {
            try {
                while (DefaultConfigUpgrade.this.parser.next() != 1 || !DefaultConfigUpgrade.this.parser.getLocalName().equals("session-manager") || sm == null) {
                }
                StoreProperties sp = (StoreProperties)sm.createChild(StoreProperties.class);
                sm.setStoreProperties(sp);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Failure creating WebContainer SessionManager StoreProperties config object", ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DefaultConfigUpgrade.class.getName()).log(Level.SEVERE, "Problem parsing web-container session-manager element in domain.xml template", ex);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdminServiceConfigCode
    implements SingleConfigCode<Config> {
        private AdminServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            AdminService adminService = (AdminService)config.createChild(AdminService.class);
            config.setAdminService(adminService);
            DasConfig dc = (DasConfig)adminService.createChild(DasConfig.class);
            adminService.setDasConfig(dc);
            for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                if (attr.equals("system-jmx-connector-name")) {
                    adminService.setSystemJmxConnectorName(val);
                }
                if (!attr.equals("type")) continue;
                adminService.setType(val);
            }
            DefaultConfigUpgrade.this.createJmxConnector(adminService);
            DefaultConfigUpgrade.this.createAdminServiceProperty(adminService);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IiopServiceConfigCode
    implements SingleConfigCode<Config> {
        private IiopServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            IiopService iiopService = (IiopService)config.createChild(IiopService.class);
            config.setIiopService(iiopService);
            DefaultConfigUpgrade.this.createOrb(iiopService);
            DefaultConfigUpgrade.this.createIiopListener(iiopService);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpServiceConfigCode
    implements SingleConfigCode<Config> {
        private HttpServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            HttpService httpService = (HttpService)config.createChild(HttpService.class);
            config.setHttpService(httpService);
            AccessLog al = (AccessLog)httpService.createChild(AccessLog.class);
            httpService.setAccessLog(al);
            DefaultConfigUpgrade.this.createVirtualServer(httpService);
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigCode
    implements SingleConfigCode<Config> {
        private DefaultConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            config.setDynamicReconfigurationEnabled(DefaultConfigUpgrade.this.parser.getAttributeValue(null, "dynamic-reconfiguration-enabled"));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinDefaultConfigCode
    implements SingleConfigCode<Configs> {
        private MinDefaultConfigCode() {
        }

        public Object run(Configs configs) throws PropertyVetoException, TransactionFailure {
            Config defaultConfig = (Config)configs.createChild(Config.class);
            defaultConfig.setName(DefaultConfigUpgrade.DEFAULT_CONFIG);
            Dom.unwrap((ConfigBeanProxy)defaultConfig).addDefaultChildren();
            configs.getConfig().add(defaultConfig);
            return defaultConfig;
        }
    }
}

