/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.Variant;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Action
implements Comparable<Action> {
    static boolean haveJavaMethods = false;
    static Method setExecutable;
    static Method setWritable;
    static Method setReadable;
    static Method setExecutable2;
    static Method setWritable2;
    static Method setReadable2;
    protected static boolean isPosix;
    static String[] posixNames;
    protected int key;
    protected Map<String, String> variants;

    Action(int k) {
        this.key = k;
        this.variants = null;
    }

    Action(int k, String[] tokens) {
        this.key = k;
        this.variants = Variant.tokensToVariantTable(tokens);
    }

    void buildFileList(Action orig, FileList flist) {
    }

    abstract void install(Action var1) throws IOException;

    void postinstall(Action orig) {
    }

    void preremove() {
    }

    void remove() throws IOException {
    }

    void postremove() {
    }

    public int getSize() {
        return 0;
    }

    @Override
    public int compareTo(Action a) {
        int diff = this.key - a.key;
        if (diff != 0) {
            return diff;
        }
        return this.keyValue().compareTo(a.keyValue());
    }

    public boolean equals(Object a) {
        return a instanceof Action && this.compareTo((Action)a) == 0;
    }

    public int hashCode() {
        return this.keyValue().hashCode();
    }

    String keyValue() {
        return "";
    }

    List<String> getReferencedDirectories() {
        return null;
    }

    void setPermissions(File file, String mode) throws IOException {
        boolean setOwnerWrite;
        int m = Integer.parseInt(mode, 8);
        if (haveJavaMethods) {
            try {
                boolean setOwnerExe = (m & 0x40) != 0;
                boolean setOtherExe = (m & 1) != 0;
                boolean setOwnerWrite2 = (m & 0x80) != 0;
                boolean setOtherWrite = (m & 2) != 0;
                boolean setOwnerRead = (m & 0x100) != 0;
                boolean setOtherRead = (m & 4) != 0;
                setExecutable2.invoke((Object)file, setOtherExe, false);
                setExecutable.invoke((Object)file, setOwnerExe);
                setWritable2.invoke((Object)file, setOtherWrite, false);
                setWritable.invoke((Object)file, setOwnerWrite2);
                setReadable2.invoke((Object)file, setOtherRead, false);
                setReadable.invoke((Object)file, setOwnerRead);
                return;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (isPosix) {
            boolean setOtherExe;
            boolean setOwnerExe = (m & 0x40) != 0;
            boolean setGroupExe = (m & 8) != 0;
            boolean bl = setOtherExe = (m & 1) != 0;
            if (file.isFile() && (setOwnerExe || setGroupExe || setOtherExe)) {
                String[] cmd = new String[]{"/bin/chmod", mode, file.getCanonicalPath()};
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                    if (p.exitValue() != 0) {
                        throw new Error("/bin/chmod failed");
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                return;
            }
        }
        boolean bl = setOwnerWrite = (m & 0x80) != 0;
        if (!setOwnerWrite) {
            file.setReadOnly();
        }
    }

    abstract boolean isDifferent(Action var1);

    static InputStream getRemoteData(Image img, Fmri fmri, String hashval) throws IOException {
        HttpURLConnection urlc = img.getRepositoryURLConnection("file/0/" + hashval, fmri);
        img.checkRepositoryConnection(urlc);
        return new GZIPInputStream(new BufferedInputStream(urlc.getInputStream()));
    }

    static {
        isPosix = false;
        posixNames = new String[]{"sunos", "linux", "mac os x", "solaris", "aix", "hp-ux", "hpux"};
        try {
            setExecutable = File.class.getMethod("setExecutable", Boolean.TYPE);
            setWritable = File.class.getMethod("setWritable", Boolean.TYPE);
            setReadable = File.class.getMethod("setReadable", Boolean.TYPE);
            setExecutable2 = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            setWritable2 = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            setReadable2 = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            haveJavaMethods = true;
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        String os = System.getProperty("os.name").toLowerCase();
        for (String p : posixNames) {
            if (os.indexOf(p) == -1) continue;
            isPosix = true;
            break;
        }
    }
}

