/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.component.Habitat;

public class LogFilterForInstance {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LogFilterForInstance.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadGivenInstanceLogFile(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        File instanceLogFile = null;
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        sshL.init(node, logger);
        SFTPClient sftpClient = sshL.getSFTPClient();
        File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
        String loggingFile = "";
        if (instanceLogFileName.contains("${com.sun.aas.instanceRoot}/logs")) {
            loggingFile = node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator + logFileName;
            if (!sftpClient.exists(loggingFile)) {
                loggingFile = node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator + "server.log";
            }
        } else {
            loggingFile = instanceLogFileName.substring(0, instanceLogFileName.lastIndexOf(File.separator)) + File.separator + logFileName;
            if (!sftpClient.exists(loggingFile)) {
                loggingFile = instanceLogFileName;
            }
        }
        long instanceLogFileSize = 0L;
        instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + loggingFile.substring(loggingFile.lastIndexOf(File.separator), loggingFile.length()));
        if (instanceLogFile.exists()) {
            instanceLogFileSize = instanceLogFile.length();
        }
        SFTPv3FileAttributes sftPv3FileAttributes = sftpClient._stat(loggingFile);
        long fileSizeOnNode = sftPv3FileAttributes.size;
        if (instanceLogFileSize != fileSizeOnNode) {
            BufferedInputStream in = null;
            FileOutputStream file = null;
            BufferedOutputStream out = null;
            try {
                int i;
                InputStream inputStream = sftpClient.read(loggingFile);
                in = new BufferedInputStream(inputStream);
                file = new FileOutputStream(instanceLogFile);
                out = new BufferedOutputStream(file);
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
            }
            finally {
                in.close();
                file.close();
                out.flush();
            }
        }
        sftpClient.close();
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        sshL.init(node, logger);
        SCPClient scpClient = sshL.getSCPClient();
        Vector allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
        File logFileDirectoryOnServer = this.makingDirectory(tempDirectoryOnServer + File.separator + "logs" + File.separator + instanceName);
        String sourceDir = "";
        sourceDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator));
        String[] remoteFileNames = new String[allInstanceLogFileName.size()];
        for (int i = 0; i < allInstanceLogFileName.size(); ++i) {
            remoteFileNames[i] = sourceDir + File.separator + allInstanceLogFileName.get(i);
        }
        scpClient.get(remoteFileNames, logFileDirectoryOnServer.getAbsolutePath());
    }

    public Vector getInstanceLogFileNames(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String instanceLogFileDirectory) throws IOException {
        String sNode = targetServer.getNodeRef();
        Node node = domain.getNodes().getNode(sNode);
        Vector<File> instanceLogFileNames = new Vector<File>();
        Vector<String> instanceLogFileNamesAsString = new Vector<String>();
        if (node.isLocal()) {
            String loggingDir = "";
            loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") ? System.getProperty("com.sun.aas.instanceRoot") + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator));
            File logsDir = new File(loggingDir);
            File[] allLogFileNames = logsDir.listFiles();
            if (allLogFileNames != null) {
                instanceLogFileNames = new Vector<File>(Arrays.asList(allLogFileNames));
            }
            for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                File file = instanceLogFileNames.get(i);
                String fileName = file.getName();
                if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                instanceLogFileNamesAsString.add(fileName);
            }
        } else {
            SSHLauncher sshL = this.getSSHL(habitat);
            sshL.init(node, logger);
            SFTPClient sftpClient = sshL.getSFTPClient();
            String loggingDir = "";
            loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator));
            instanceLogFileNames = sftpClient.ls(loggingDir);
            for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                SFTPv3DirectoryEntry file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                String fileName = file.filename;
                if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                instanceLogFileNamesAsString.add(fileName);
            }
        }
        return instanceLogFileNamesAsString;
    }

    private SSHLauncher getSSHL(Habitat habitat) {
        SSHLauncher sshL = null;
        try {
            sshL = (SSHLauncher)habitat.getComponent(SSHLauncher.class);
        }
        catch (NoClassDefFoundError ex) {
            throw new NoClassDefFoundError(localStrings.getLocalString("collectlogfiles.missingclusterlibraries", "Missing Cluster libraries in your ClassPath."));
        }
        return sshL;
    }

    private File makingDirectory(String path) {
        File targetDir = new File(path);
        boolean created = false;
        boolean deleted = false;
        if (targetDir.exists() && !(deleted = targetDir.delete())) {
            return targetDir;
        }
        created = targetDir.mkdir();
        if (!created) {
            return null;
        }
        return targetDir;
    }
}

