/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jar")
@Scoped(value=PerLookup.class)
public class OutputJarArchive
extends JarArchive
implements WritableArchive {
    private URI uri;
    protected ZipOutputStream jos = null;
    private Manifest manifest = null;
    private Vector entries = new Vector();

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return -1L;
    }

    public void close() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.finish();
            this.jos.close();
            this.jos = null;
        }
    }

    @Override
    protected JarEntry getJarEntry(String entryName) {
        return null;
    }

    public void create(URI path) throws IOException {
        boolean isDeleted;
        this.uri = path;
        File file = new File(this.uri.getSchemeSpecificPart());
        if (file.exists() && !(isDeleted = file.delete())) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error in deleting file " + file.getAbsolutePath());
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.jos = new ZipOutputStream(bos);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public Collection<String> getDirectories() throws IOException {
        return new Vector<String>();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public URI getURI() {
        return this.uri;
    }

    public WritableArchive createSubArchive(String name) throws IOException {
        OutputStream os = this.putNextEntry(name);
        ZipOutputStream jos = new ZipOutputStream(os);
        OutputJarArchive ja = new OutputJarArchive();
        try {
            ja.uri = new URI("jar", name, null);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        ja.jos = jos;
        return ja;
    }

    public void closeEntry(WritableArchive subArchive) throws IOException {
        if (subArchive instanceof OutputJarArchive) {
            ((OutputJarArchive)subArchive).jos.flush();
            ((OutputJarArchive)subArchive).jos.finish();
        }
        this.jos.closeEntry();
    }

    public OutputStream putNextEntry(String name) throws IOException {
        if (this.jos != null) {
            ZipEntry ze = new ZipEntry(name);
            this.jos.putNextEntry(ze);
            this.entries.add(name);
        }
        return this.jos;
    }

    public void closeEntry() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.closeEntry();
        }
    }
}

