/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="collect-log-files")
@Scoped(value=PerLookup.class)
@I18n(value="collect.log.files")
public class CollectLogFiles
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectLogFiles.class);
    private static final Logger logger = LogDomains.getLogger(CollectLogFiles.class, (String)"javax.enterprise.system.core");
    @Param(optional=true)
    String target = "server";
    @Param(name="retrieve", optional=true, defaultValue="false")
    boolean retrieve;
    @Param(primary=true, optional=true, defaultValue=".")
    private String retrieveFilePath;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    private Habitat habitat;
    @Inject
    LoggingConfigImpl loggingConfig;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Properties props = this.initFileXferProps();
        Server targetServer = this.domain.getServerNamed(this.target);
        File retrieveFile = this.makingDirectory(this.retrieveFilePath, report, localStrings.getLocalString("collectlogfiles.outputPath.notexist", "Retrieve File Path does not exist. Please enter correct value for Retrieve File Path."));
        if (targetServer != null && targetServer.isDas()) {
            String errorMsg;
            String logFileDetails = "";
            try {
                logFileDetails = this.loggingConfig.getLoggingFileDetails();
            }
            catch (Exception ex) {
                String errorMsg2 = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
            }
            String zipFile = "";
            File tempDirectory = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
            File targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            targetDirPath = targetDir.getAbsolutePath() + File.separator + targetServer.getName();
            targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            try {
                String sourceDir = "";
                sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getDomainRoot() + File.separator + "logs" : logFileDetails.substring(0, logFileDetails.lastIndexOf(File.separator));
                this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, targetServer.getName());
            }
            catch (Exception ex) {
                errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
            }
            try {
                zipFile = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                if (zipFile == null || new File(zipFile) == null) {
                    String errorMsg3 = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(errorMsg3);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception e) {
                errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                logger.log(Level.SEVERE, errorMsg, e);
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.retrieve) {
                this.retrieveFile(zipFile, context, tempDirectory, props, report);
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", new Object[]{this.retrieveFilePath + File.separator + new File(zipFile).getName()}));
            } else {
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", new Object[]{zipFile}));
            }
            if (targetDir != null && targetDir.exists()) {
                this.deleteDir(targetDir);
            }
        } else if (targetServer != null && targetServer.isInstance()) {
            String errorMsg;
            String instanceName = targetServer.getName();
            String serverNode = targetServer.getNodeRef();
            Node node = this.domain.getNodes().getNode(serverNode);
            File tempDirectory = null;
            String zipFile = "";
            File targetDir = null;
            String logFileDetails = "";
            try {
                logFileDetails = this.getInstanceLogFileDirectory(targetServer);
            }
            catch (Exception ex) {
                errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
            }
            tempDirectory = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            try {
                if (node.isLocal()) {
                    String sourceDir = "";
                    sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getInstanceRoot().getAbsolutePath() + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + serverNode + File.separator + instanceName + File.separator + "logs" : logFileDetails.substring(0, logFileDetails.lastIndexOf(File.separator));
                    String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
                    targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
                    targetDirPath = targetDir.getAbsolutePath() + File.separator + targetServer.getName();
                    targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
                    this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                } else {
                    new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, targetServer, this.domain, logger, instanceName, tempDirectory.getAbsolutePath(), logFileDetails);
                }
            }
            catch (Exception ex) {
                errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{instanceName});
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                zipFile = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                if (zipFile == null || new File(zipFile) == null) {
                    String errorMsg4 = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(errorMsg4);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception ex) {
                errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.retrieve) {
                this.retrieveFile(zipFile, context, tempDirectory, props, report);
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", new Object[]{this.retrieveFilePath + File.separator + new File(zipFile).getName()}));
            } else {
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", new Object[]{zipFile}));
            }
            if (targetDir != null && targetDir.exists()) {
                this.deleteDir(targetDir);
            }
        } else {
            String finalMessage = "";
            File tempDirectory = null;
            String zipFile = "";
            File targetDir = null;
            tempDirectory = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            String logFileDetails = "";
            try {
                logFileDetails = this.loggingConfig.getLoggingFileDetails();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
            }
            String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
            targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            targetDirPath = targetDir.getAbsolutePath() + File.separator + "server";
            targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
            try {
                String sourceDir = "";
                sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getDomainRoot() + File.separator + "logs" : logFileDetails.substring(0, logFileDetails.lastIndexOf(File.separator));
                this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, "server");
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
            }
            Cluster cluster = this.domain.getClusterNamed(this.target);
            List instances = cluster.getInstances();
            int instanceCount = 0;
            int errorCount = 0;
            for (Server instance : instances) {
                String errorMsg;
                String instanceName = instance.getName();
                String serverNode = instance.getNodeRef();
                Node node = this.domain.getNodes().getNode(serverNode);
                boolean errorOccur = false;
                ++instanceCount;
                logFileDetails = "";
                try {
                    logFileDetails = this.getInstanceLogFileDirectory(this.domain.getServerNamed(instanceName));
                }
                catch (Exception ex) {
                    errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{this.target});
                }
                try {
                    if (node.isLocal()) {
                        String sourceDir = "";
                        sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getInstanceRoot().getAbsolutePath() + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + serverNode + File.separator + instanceName + File.separator + "logs" : logFileDetails.substring(0, logFileDetails.lastIndexOf(File.separator));
                        targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs" + File.separator + instanceName;
                        targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
                        this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                    } else {
                        new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, instance, this.domain, logger, instanceName, tempDirectory.getAbsolutePath(), logFileDetails);
                    }
                }
                catch (Exception ex) {
                    ++errorCount;
                    errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", new Object[]{instanceName});
                    errorOccur = true;
                    finalMessage = finalMessage + errorMsg + "\n";
                }
                if (errorOccur) continue;
                String successMsg = localStrings.getLocalString("collectlogfiles.successInstanceDownloading", "Log files are downloaded for {0}.", new Object[]{instanceName});
                finalMessage = finalMessage + successMsg + "\n";
            }
            report.setMessage(finalMessage);
            if (instanceCount != errorCount) {
                try {
                    zipFile = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                    if (zipFile == null || new File(zipFile) == null) {
                        String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage(errorMsg);
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                }
                catch (Exception ex) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", new Object[]{zipFile});
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.retrieve) {
                    this.retrieveFile(zipFile, context, tempDirectory, props, report);
                    report.setMessage(localStrings.getLocalString("collectlogfiles.cluster.success", "{0} Created Zip file under {1}.", new Object[]{finalMessage, this.retrieveFilePath + File.separator + new File(zipFile).getName()}));
                } else {
                    report.setMessage(localStrings.getLocalString("collectlogfiles.cluster.success", "{0} Created Zip file under {1}.", new Object[]{finalMessage, zipFile}));
                }
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else if (instanceCount == 0) {
                report.setMessage(localStrings.getLocalString("collectlogfiles.noinstance", "No instances are defined as part of {0}. So there are no files to zip.", new Object[]{this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            if (targetDir != null && targetDir.exists()) {
                this.deleteDir(targetDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLogFilesForLocalhost(String sourceDir, String targetDir, ActionReport report, String instanceName) throws IOException {
        File logsDir = new File(sourceDir);
        File[] allLogFileNames = logsDir.listFiles();
        if (allLogFileNames == null) {
            throw new IOException("");
        }
        for (File logFile : allLogFileNames) {
            if (!logFile.isFile()) continue;
            File toFile = new File(targetDir, logFile.getName());
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = new FileInputStream(logFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from {0}.", new Object[]{instanceName});
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            finally {
                from.close();
                to.close();
            }
            if (toFile.exists()) continue;
            String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from {0}.", new Object[]{instanceName});
            report.setMessage(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private Properties initFileXferProps() {
        Properties props = new Properties();
        props.setProperty("file-xfer-root", this.retrieveFilePath.replace("\\", "/"));
        return props;
    }

    private void retrieveFile(String zipFileName, AdminCommandContext context, File tempDirectory, Properties props, ActionReport report) {
        Payload.Outbound outboundPayload = context.getOutboundPayload();
        try {
            File zipFile = new File(zipFileName);
            outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(zipFile.toURI()), "files", props, zipFile);
        }
        catch (Exception ex) {
            String errorMsg = localStrings.getLocalString("collectlogfiles.copyingZip", "Error while copying zip file to {0}.", new Object[]{this.retrieveFilePath});
            logger.log(Level.SEVERE, errorMsg, ex);
            report.setMessage(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private String getInstanceLogFileDirectory(Server targetServer) throws IOException {
        String logFileDetailsForServer = "";
        String targetConfigName = "";
        Cluster clusterForInstance = targetServer.getCluster();
        targetConfigName = clusterForInstance != null ? clusterForInstance.getConfigRef() : targetServer.getConfigRef();
        logFileDetailsForServer = this.loggingConfig.getLoggingFileDetails(targetConfigName);
        return logFileDetailsForServer;
    }

    private File makingDirectory(String path, ActionReport report, String errorMsg) {
        File targetDir = new File(path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }

    private File makingDirectory(File parent, String path, ActionReport report, String errorMsg) {
        File targetDir = new File(parent, path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }
}

