/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.container.Sniffer;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class WebContainerStarter
implements Startup,
PostConstruct,
ConfigListener {
    private static final Logger logger = LogDomains.getLogger(WebContainerStarter.class, (String)"javax.enterprise.system.core");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final String AUTH_PASSTHROUGH_ENABLED_PROP = "authPassthroughEnabled";
    private static final String PROXY_HANDLER_PROP = "proxyHandler";
    private static final String TRACE_ENABLED_PROP = "traceEnabled";
    @Inject
    private Domain domain;
    @Inject
    private ContainerRegistry containerRegistry;
    @Inject
    private ContainerStarter containerStarter;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject(name="default-instance-name")
    private Config serverConfig;
    @Inject
    private Habitat habitat;

    public void postConstruct() {
        boolean isStartNeeded = false;
        if (this.serverConfig != null) {
            if (this.isStartNeeded(this.serverConfig.getHttpService())) {
                isStartNeeded = true;
            }
            if (!isStartNeeded && this.isStartNeeded(this.serverConfig.getNetworkConfig())) {
                isStartNeeded = true;
            }
        }
        if (isStartNeeded) {
            this.startWebContainer();
        } else {
            ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.serverConfig.getHttpService());
            bean.addListener((ConfigListener)this);
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.serverConfig.getNetworkConfig().getNetworkListeners());
            bean.addListener((ConfigListener)this);
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (t instanceof HttpService) {
                    if (type == Changed.TYPE.CHANGE && WebContainerStarter.this.isStartNeeded((HttpService)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (t instanceof VirtualServer) {
                    if ((type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((VirtualServer)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (t instanceof NetworkListener && (type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((NetworkListener)t)) {
                    WebContainerStarter.this.startWebContainer();
                }
                return null;
            }
        }, (Logger)logger);
    }

    private void startWebContainer() {
        Sniffer webSniffer = (Sniffer)this.habitat.getComponent(Sniffer.class, "web");
        if (webSniffer == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("core.web_container_not_installed");
            }
            return;
        }
        if (this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]) != null) {
            this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]).getContainer();
        } else {
            Module snifferModule = this.modulesRegistry.find(webSniffer.getClass());
            try {
                Collection<EngineInfo> containersInfo = this.containerStarter.startContainer(webSniffer, snifferModule);
                if (containersInfo != null && !containersInfo.isEmpty()) {
                    for (EngineInfo info : containersInfo) {
                        info.getContainer();
                        if (!logger.isLoggable(Level.INFO)) continue;
                        logger.log(Level.INFO, "core.start_container_done", webSniffer.getModuleType());
                    }
                } else {
                    logger.severe("core.unable_start_container_no_exception");
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format(rb.getString("core.unable_start_container"), webSniffer.getContainersNames()[0]);
                logger.log(Level.SEVERE, msg, e);
            }
        }
    }

    private boolean isStartNeeded(HttpService httpService) {
        List hosts;
        if (httpService == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)httpService.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)httpService.getSsoEnabled())) {
            return true;
        }
        List props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                String propName = prop.getName();
                String propValue = prop.getValue();
                if (AUTH_PASSTHROUGH_ENABLED_PROP.equals(propName)) {
                    if (!ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                    return true;
                }
                if (PROXY_HANDLER_PROP.equals(propName)) {
                    return true;
                }
                if (!TRACE_ENABLED_PROP.equals(propName) || ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                return true;
            }
        }
        if ((hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if (!this.isStartNeeded(host)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStartNeeded(VirtualServer host) {
        if (host == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)host.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)host.getSsoEnabled())) {
            return true;
        }
        String state = host.getState();
        if (state != null && ("disabled".equals(state) || !ConfigBeansUtilities.toBoolean((String)state))) {
            return true;
        }
        List props = host.getProperty();
        return props != null && !props.isEmpty();
    }

    private boolean isStartNeeded(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            return false;
        }
        NetworkListeners networkListeners = networkConfig.getNetworkListeners();
        if (networkListeners == null) {
            return false;
        }
        for (NetworkListener networkListener : networkListeners.getNetworkListener()) {
            if (!this.isStartNeeded(networkListener)) continue;
            return true;
        }
        return false;
    }

    private boolean isStartNeeded(NetworkListener networkListener) {
        if (networkListener == null) {
            return false;
        }
        return ConfigBeansUtilities.toBoolean((String)networkListener.getJkEnabled());
    }
}

