/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;

class FelixDeployer
implements Runnable {
    private final Resolver obrResolver;
    private final AbstractWebConsolePlugin logger;
    private final boolean startBundles;
    private final boolean optionalDependencies;

    static void deploy(Resolver obrResolver, AbstractWebConsolePlugin logger, boolean startBundles, boolean optionalDependencies) {
        FelixDeployer d = new FelixDeployer(obrResolver, logger, startBundles, optionalDependencies);
        Thread t = new Thread((Runnable)d, "OBR Bundle Deployer (Apache Felix API)");
        t.start();
    }

    private FelixDeployer(Resolver obrResolver, AbstractWebConsolePlugin logger, boolean startBundles, boolean optionalDependencies) {
        this.obrResolver = obrResolver;
        this.logger = logger;
        this.startBundles = startBundles;
        this.optionalDependencies = optionalDependencies;
    }

    public void run() {
        int flags = 0;
        flags += this.startBundles ? 16 : 0;
        flags += this.optionalDependencies ? 0 : 1;
        try {
            if (this.obrResolver.resolve(flags)) {
                this.logResource("Installing Requested Resources", this.obrResolver.getAddedResources());
                this.logResource("Installing Required Resources", this.obrResolver.getRequiredResources());
                this.logResource("Installing Optional Resources", this.obrResolver.getOptionalResources());
                this.obrResolver.deploy(flags);
            } else {
                this.logRequirements("Cannot Install requested bundles due to unsatisfied requirements", this.obrResolver.getUnsatisfiedRequirements());
            }
        }
        catch (Exception ie) {
            this.logger.log(1, "Cannot install bundles", ie);
        }
    }

    private void logResource(String message, Resource[] res) {
        if (res != null && res.length > 0) {
            this.logger.log(3, message);
            for (int i = 0; i < res.length; ++i) {
                this.logger.log(3, "  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    private void logRequirements(String message, Reason[] reasons) {
        this.logger.log(1, message);
        for (int i = 0; reasons != null && i < reasons.length; ++i) {
            String moreInfo = reasons[i].getRequirement().getComment();
            if (moreInfo == null) {
                moreInfo = reasons[i].getRequirement().getFilter().toString();
            }
            this.logger.log(1, "  " + i + ": " + reasons[i].getRequirement().getName() + " (" + moreInfo + ")");
        }
    }
}

