/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.obr.AbstractBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.internal.obr.FelixBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.internal.obr.OsgiBundleRepositoryRenderHelper;

public class BundleRepositoryRender
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "obr";
    private static final String TITLE = "OSGi Repository";
    private static final String[] CSS = new String[]{"/res/ui/obr.css"};
    private final String TEMPLATE = this.readTemplateFile("/templates/obr.html");
    private AbstractBundleRepositoryRenderHelper helper;

    public BundleRepositoryRender() {
        super(LABEL, TITLE, CSS);
    }

    public void deactivate() {
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
        super.deactivate();
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", this.getData(request));
        response.getWriter().print(this.TEMPLATE);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.hasRepositoryAdmin()) {
            response.sendError(500, "RepositoryAdmin service is missing");
            return;
        }
        String action = request.getParameter("action");
        String deploy = request.getParameter("deploy");
        String deploystart = request.getParameter("deploystart");
        String optional = request.getParameter("optional");
        if (action != null) {
            this.doAction(action, request.getParameter("url"));
            response.getWriter().print(this.getData(request));
            return;
        }
        if (deploy != null || deploystart != null) {
            this.doDeploy(request.getParameterValues("bundle"), deploystart != null, optional != null);
            this.doGet(request, response);
            return;
        }
        super.doPost(request, response);
    }

    AbstractBundleRepositoryRenderHelper getHelper() {
        if (this.helper == null) {
            try {
                this.helper = new FelixBundleRepositoryRenderHelper(this, this.getBundleContext());
            }
            catch (Throwable felixt) {
                try {
                    this.helper = new OsgiBundleRepositoryRenderHelper(this, this.getBundleContext());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.helper;
    }

    private boolean hasRepositoryAdmin() {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        return helper != null && helper.hasRepositoryAdmin();
    }

    private String getData(HttpServletRequest request) {
        String filter;
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper == null || !helper.hasRepositoryAdmin()) {
            return "{}";
        }
        RequestInfo info = new RequestInfo(request);
        String list = info.getList();
        if (list != null) {
            if ("-".equals(list)) {
                StringBuffer sb = new StringBuffer("(!(|");
                for (int c = 0; c < 26; ++c) {
                    sb.append("(presentationname=").append((char)(97 + c)).append("*)(presentationname=").append((char)(65 + c)).append("*)");
                }
                sb.append("))");
                filter = sb.toString();
            } else {
                filter = "(|(presentationname=" + list.toLowerCase() + "*)(presentationname=" + list.toUpperCase() + "*))";
            }
        } else {
            String query = info.getQuery();
            if (query != null) {
                filter = query.indexOf(61) > 0 ? (query.startsWith("(") ? query : "(" + query + ")") : "(|(presentationame=*" + query + "*)(symbolicname=*" + query + "*))";
            } else {
                StringBuffer sb = new StringBuffer("(&");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    String v = request.getParameter(k);
                    if (v == null || v.length() <= 0 || "details".equals(k) || "deploy".equals(k) || "deploystart".equals(k) || "bundle".equals(k) || "optional".equals(k)) continue;
                    sb.append("(").append(k).append("=").append(v).append(")");
                }
                sb.append(")");
                filter = sb.length() > 3 ? sb.toString() : null;
            }
        }
        return helper.getData(filter, info.showDetails(), this.getBundleContext().getBundles());
    }

    private void doAction(String action, String urlParam) throws IOException, ServletException {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper != null) {
            helper.doAction(action, urlParam);
        }
    }

    private void doDeploy(String[] bundles, boolean start, boolean optional) {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper != null) {
            helper.doDeploy(bundles, start, optional);
        }
    }

    private static class RequestInfo {
        private final HttpServletRequest request;
        private boolean details;
        private String query;
        private String list;

        RequestInfo(HttpServletRequest request) {
            this.request = request;
        }

        boolean showDetails() {
            this.getQuery();
            return this.details;
        }

        String getQuery() {
            if (this.query == null) {
                String query = WebConsoleUtil.urlDecode(this.request.getParameter("query"));
                boolean details = false;
                if (query == null && this.request.getPathInfo().length() > 5) {
                    String path = this.request.getPathInfo().substring(5);
                    int slash = path.indexOf(47);
                    if (slash < 0) {
                        query = "(symbolicname=" + path + ")";
                    } else {
                        query = "(&(symbolicname=" + path.substring(0, slash) + ")(version=" + path.substring(slash + 1) + "))";
                        details = true;
                    }
                }
                this.query = query;
                this.details = details;
            }
            return this.query;
        }

        String getList() {
            if (this.list == null) {
                this.list = WebConsoleUtil.urlDecode(this.request.getParameter("list"));
                if (this.list == null && !this.request.getParameterNames().hasMoreElements() && this.getQuery() == null) {
                    this.list = "a";
                }
            }
            return this.list;
        }
    }
}

