/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgihttp;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.glassfish.web.osgihttp.DefaultHttpContext;
import org.glassfish.web.osgihttp.GlassFishHttpService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceWrapper
implements HttpService {
    private GlassFishHttpService delegate;
    private Bundle registeringBundle;
    private Set<String> aliases = new HashSet<String>();

    public HttpServiceWrapper(GlassFishHttpService delegate, Bundle registeringBundle) {
        this.delegate = delegate;
        this.registeringBundle = registeringBundle;
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.registeringBundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        this.delegate.registerServlet(alias, servlet, initParams, httpContext);
        this.aliases.add(alias);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        this.delegate.registerResources(alias, name, httpContext);
        this.aliases.add(alias);
    }

    public synchronized void unregister(String alias) {
        this.unregister(alias, true);
    }

    private void unregister(String alias, boolean callDestroy) {
        this.delegate.unregister(alias, callDestroy);
        this.aliases.remove(alias);
    }

    void unregisterAll() {
        for (String alias : this.aliases.toArray(new String[0])) {
            this.unregister(alias, false);
        }
    }

    public static class HttpServiceFactory
    implements ServiceFactory {
        private GlassFishHttpService delegate;

        public HttpServiceFactory(GlassFishHttpService delegate) {
            this.delegate = delegate;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return new HttpServiceWrapper(this.delegate, bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            ((HttpServiceWrapper)HttpServiceWrapper.class.cast(service)).unregisterAll();
        }
    }
}

