/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;

public class OSGiResourceServlet
extends HttpServlet {
    private String alias;
    private String name;
    private HttpContext httpContext;

    public OSGiResourceServlet(String alias, String name, HttpContext httpContext) {
        this.alias = alias;
        this.name = name;
        this.httpContext = httpContext;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String resPath = this.getResourcePath(req);
        URL url = this.httpContext.getResource(resPath);
        if (url == null) {
            resp.sendError(404);
            return;
        }
        String mimeType = this.httpContext.getMimeType(resPath);
        if (mimeType == null) {
            mimeType = this.getServletConfig().getServletContext().getMimeType(resPath);
        }
        resp.setContentType(mimeType);
        URLConnection conn = url.openConnection();
        int writeCount = this.writeToStream(conn, (OutputStream)resp.getOutputStream());
        resp.setContentLength(writeCount);
        resp.setStatus(200);
    }

    private String getResourcePath(HttpServletRequest req) {
        String requestURI;
        String servletPath = req.getServletPath();
        assert (servletPath == this.alias);
        String contextPath = req.getContextPath();
        try {
            requestURI = new URI(req.getRequestURI()).normalize().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String requestedPath = requestURI.substring(contextPath.length());
        StringBuilder mappedPath = new StringBuilder(requestedPath);
        String internalName = this.name == "/" ? "" : this.name;
        mappedPath.replace(0, servletPath.length(), internalName);
        System.out.println("Mapped [" + requestedPath + "] to [" + mappedPath + "]");
        return mappedPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToStream(URLConnection connection, OutputStream os) throws IOException {
        InputStream is = connection.getInputStream();
        try {
            byte[] buf = new byte[8192];
            int readCount = is.read(buf);
            int writeCount = 0;
            while (readCount != -1) {
                os.write(buf, 0, readCount);
                writeCount += readCount;
                readCount = is.read(buf);
            }
            int n = writeCount;
            return n;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

