/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.glassfish.osgihttp.OSGiResourceServlet;
import org.glassfish.osgihttp.OSGiSecurityValve;
import org.glassfish.osgihttp.OSGiServletConfig;
import org.glassfish.osgihttp.OSGiServletContext;
import org.glassfish.osgihttp.OSGiServletWrapper;
import org.glassfish.web.valve.GlassFishValve;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class GlassFishHttpService {
    private Context context;
    private Map<HttpContext, OSGiServletContext> servletContextMap = new HashMap<HttpContext, OSGiServletContext>();

    public GlassFishHttpService(Context context) {
        this.context = context;
    }

    public synchronized void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws NamespaceException, ServletException {
        this.validateAlias(alias);
        this.validateServlet(servlet);
        OSGiServletContext servletContext = this.servletContextMap.get(httpContext);
        if (servletContext == null) {
            servletContext = new OSGiServletContext(this.context.getServletContext(), httpContext);
            this.servletContextMap.put(httpContext, servletContext);
        }
        String wrapperName = alias;
        OSGiServletConfig servletConfig = new OSGiServletConfig(wrapperName, servletContext, initParams);
        OSGiServletWrapper wrapper = new OSGiServletWrapper(wrapperName, servlet, servletConfig, this.convert(alias));
        this.context.addChild((Container)wrapper);
        try {
            wrapper.initializeServlet();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public synchronized void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.validateAlias(alias);
        this.validateName(name);
        OSGiResourceServlet servlet = new OSGiResourceServlet(alias, name, httpContext);
        OSGiServletContext servletContext = this.servletContextMap.get(httpContext);
        if (servletContext == null) {
            servletContext = new OSGiServletContext(this.context.getServletContext(), httpContext);
            this.servletContextMap.put(httpContext, servletContext);
        }
        String wrapperName = alias;
        OSGiServletConfig servletConfig = new OSGiServletConfig(wrapperName, servletContext, null);
        OSGiServletWrapper wrapper = new OSGiServletWrapper(wrapperName, (Servlet)servlet, servletConfig, this.convert(alias));
        wrapper.addValve((GlassFishValve)new OSGiSecurityValve(httpContext));
        this.context.addChild((Container)wrapper);
        try {
            wrapper.initializeServlet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void unregister(String alias, boolean callDestroy) {
        OSGiServletWrapper wrapper = this.getWrapper(alias);
        if (wrapper == null) {
            throw new IllegalArgumentException("No registration exists for " + alias);
        }
        this.context.removeChild((Container)wrapper);
        if (callDestroy) {
            wrapper.destroyServlet();
        }
    }

    private OSGiServletWrapper getWrapper(String alias) {
        String wrapperName = alias;
        OSGiServletWrapper wrapper = (OSGiServletWrapper)this.context.findChild(wrapperName);
        return wrapper;
    }

    private void validateServlet(Servlet servlet) throws ServletException {
        for (Container c : this.context.findChildren()) {
            if (!(c instanceof OSGiServletWrapper) || servlet != ((OSGiServletWrapper)((Object)OSGiServletWrapper.class.cast(c))).getServlet()) continue;
            throw new ServletException("servlet is already registered");
        }
    }

    private void validateAlias(String alias) throws NamespaceException {
        if (!(alias.equals("/") || alias.startsWith("/") && !alias.endsWith("/"))) {
            throw new IllegalArgumentException("malformed alias");
        }
        if (this.getWrapper(alias) != null) {
            throw new NamespaceException("alias already registered");
        }
    }

    private String convert(String alias) {
        if (alias.equals("/")) {
            return "/*";
        }
        return alias + "/*";
    }

    private void validateName(String name) {
        if (name.endsWith("/")) {
            throw new IllegalArgumentException("name ends with '/'");
        }
    }
}

