/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgihttp.GlassFishHttpService;
import org.glassfish.osgihttp.HttpServiceWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class Activator
implements BundleActivator {
    private BundleContext bctx;
    private Host vs;
    private String contextPath;
    private ServiceRegistration registration;
    private static final String VS_ID_PROP = Activator.class.getPackage().getName() + ".VirtualServerId";
    private static final String CONTEXT_PATH_PROP = Activator.class.getPackage().getName() + ".ContextPath";

    public void start(BundleContext context) throws Exception {
        this.bctx = context;
        StandardContext standardContext = this.getStandardContext(context);
        GlassFishHttpService httpService = new GlassFishHttpService((Context)standardContext);
        this.registration = context.registerService(HttpService.class.getName(), (Object)new HttpServiceWrapper.HttpServiceFactory(httpService), null);
    }

    private StandardContext getStandardContext(BundleContext context) throws Exception {
        WebContainer webContainer = (WebContainer)Globals.get(WebContainer.class);
        Engine engine = webContainer.getEngine();
        String vsId = context.getProperty(VS_ID_PROP);
        if (vsId == null) {
            vsId = "server";
        }
        this.vs = (Host)engine.findChild(vsId);
        if (this.vs == null) {
            throw new Exception("No virtual host by name : " + vsId + ". Please specify virtual server name using property called " + VS_ID_PROP);
        }
        this.contextPath = context.getProperty(CONTEXT_PATH_PROP);
        if (this.contextPath == null) {
            this.contextPath = "/osgi";
        }
        WebModule standardContext = new WebModule();
        standardContext.setWebContainer(webContainer);
        standardContext.setName(this.contextPath);
        standardContext.setPath(this.contextPath);
        standardContext.setDocBase(System.getProperty("java.io.tmpdir"));
        standardContext.setWorkDir(System.getProperty("java.io.tmpdir"));
        standardContext.setJ2EEServer("server");
        standardContext.addLifecycleListener((LifecycleListener)new ContextConfig());
        Realm realm = (Realm)Globals.getDefaultHabitat().getByContract(Realm.class);
        standardContext.setRealm(realm);
        WebModuleConfig wmConfig = new WebModuleConfig();
        wmConfig.setWorkDirBase(System.getProperty("java.io.tmpdir"));
        wmConfig.setVirtualServers(vsId);
        standardContext.setParentClassLoader(this.getCommonClassLoader());
        standardContext.setWebModuleConfig(wmConfig);
        this.switchOffSessionPersistence((StandardContext)standardContext);
        this.vs.addChild((Container)standardContext);
        return standardContext;
    }

    private ClassLoader getCommonClassLoader() {
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)Globals.getDefaultHabitat().getComponent(ClassLoaderHierarchy.class);
        return clh.getAPIClassLoader();
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        StandardContext standardContext = (StandardContext)StandardContext.class.cast(this.vs.findChild(this.contextPath));
        for (Container child : standardContext.findChildren()) {
            standardContext.removeChild(child);
        }
        this.vs.removeChild((Container)standardContext);
    }

    private void switchOffSessionPersistence(StandardContext ctx) {
        Manager mgr = ctx.getManager();
        if (mgr == null) {
            mgr = new StandardManager();
            ((StandardManager)StandardManager.class.cast(mgr)).setPathname(null);
            ctx.setManager(mgr);
        } else {
            try {
                ((StandardManager)StandardManager.class.cast(mgr)).setPathname(null);
            }
            catch (ClassCastException cce) {
                System.out.println(mgr + " does not allow path name of session store to be configured.");
            }
        }
    }
}

