/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.BrowserSupport;
import com.sun.servicetag.Installer;
import com.sun.servicetag.RegistrationData;
import com.sun.servicetag.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;

class SunConnection {
    private static String JDK_REGISTRATION_URL = "https://inventory.sun.com/RegistrationWeb/register";
    private static String SANDBOX_TESTING_URL = "https://connection-tst.sun.com/RegistrationWeb/register";
    private static String SVCTAG_REGISTER_TESTING = "servicetag.register.testing";
    private static String SVCTAG_REGISTRATION_URL = "servicetag.registration.url";
    private static String SVCTAG_CONNECTION_TIMEOUT = "servicetag.connection.timeout";

    private SunConnection() {
    }

    static URL getRegistrationURL(String registrationURN) {
        String url = System.getProperty(SVCTAG_REGISTRATION_URL);
        if (url == null) {
            url = System.getProperty(SVCTAG_REGISTER_TESTING) != null ? SANDBOX_TESTING_URL : JDK_REGISTRATION_URL;
        }
        if ((url = url.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        String registerURL = SunConnection.rewriteURL(url, registrationURN);
        try {
            return new URL(registerURL);
        }
        catch (MalformedURLException ex) {
            InternalError x = new InternalError(ex.getMessage());
            x.initCause(ex);
            throw x;
        }
    }

    private static String rewriteURL(String url, String registryURN) {
        int len;
        StringBuilder sb = new StringBuilder(url.trim());
        if (sb.charAt((len = sb.length()) - 1) != '/') {
            sb.append('/');
        }
        sb.append(registryURN);
        sb.append("?");
        sb.append("product=jdk");
        sb.append("&");
        sb.append("locale=").append(Locale.getDefault().getLanguage());
        return sb.toString();
    }

    public static void register(RegistrationData regData) throws IOException {
        URL url = SunConnection.getRegistrationURL(regData.getRegistrationURN());
        boolean succeed = SunConnection.postRegistrationData(url, regData);
        if (succeed) {
            SunConnection.openBrowser(url);
        } else {
            SunConnection.openOfflineRegisterPage();
        }
    }

    private static void openBrowser(URL url) throws IOException {
        block7: {
            if (!BrowserSupport.isSupported()) {
                if (Util.isVerbose()) {
                    System.out.println("Browser is not supported");
                }
                return;
            }
            try {
                BrowserSupport.browse(url.toURI());
            }
            catch (URISyntaxException ex) {
                InternalError x = new InternalError("Error in registering: " + ex.getMessage());
                x.initCause(ex);
                throw x;
            }
            catch (IllegalArgumentException ex) {
                if (Util.isVerbose()) {
                    ex.printStackTrace();
                }
            }
            catch (UnsupportedOperationException ex) {
                if (!Util.isVerbose()) break block7;
                ex.printStackTrace();
            }
        }
    }

    private static boolean postRegistrationData(URL url, RegistrationData registration) {
        try {
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            String timeout = System.getProperty(SVCTAG_CONNECTION_TIMEOUT, "10");
            con.setConnectTimeout(Util.getIntValue(timeout) * 1000);
            if (Util.isVerbose()) {
                System.out.println("Connecting to post registration data at " + url);
            }
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
            con.connect();
            OutputStream out = con.getOutputStream();
            registration.storeToXML(out);
            out.flush();
            out.close();
            int returnCode = con.getResponseCode();
            if (Util.isVerbose()) {
                System.out.println("POST return status = " + returnCode);
                SunConnection.printReturnData(con, returnCode);
            }
            return returnCode == 200;
        }
        catch (MalformedURLException me) {
            InternalError x = new InternalError("Error in registering: " + me.getMessage());
            x.initCause(me);
            throw x;
        }
        catch (Exception ioe) {
            if (Util.isVerbose()) {
                ioe.printStackTrace();
            }
            return false;
        }
    }

    private static void openOfflineRegisterPage() throws IOException {
        block7: {
            if (!BrowserSupport.isSupported()) {
                if (Util.isVerbose()) {
                    System.out.println("Browser is not supported");
                }
                return;
            }
            File registerPage = Installer.getRegistrationHtmlPage();
            try {
                BrowserSupport.browse(registerPage.toURI());
            }
            catch (FileNotFoundException ex) {
                InternalError x = new InternalError("Error in launching " + registerPage + ": " + ex.getMessage());
                x.initCause(ex);
                throw x;
            }
            catch (IllegalArgumentException ex) {
                if (Util.isVerbose()) {
                    ex.printStackTrace();
                }
            }
            catch (UnsupportedOperationException ex) {
                if (!Util.isVerbose()) break block7;
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printReturnData(HttpURLConnection con, int returnCode) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = returnCode < 400 ? new BufferedReader(new InputStreamReader(con.getInputStream())) : new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            System.out.println("Response is : ");
            System.out.println(sb.toString());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

