/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.enterprise.registration.impl.SysnetRegistrationService;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="SysnetTransferService")
public class TransferService
implements PostStartup,
PostConstruct {
    @Inject
    Logger logger;
    private static final long TIMER_INTERVAL = Long.getLong("com.sun.enterprise.registration.TRANSFER_TIMER_INTERVAL", 10080L) * 60L * 1000L;

    public int priority() {
        return 1;
    }

    public void postConstruct() {
        if (TIMER_INTERVAL < 0L) {
            return;
        }
        final SysnetRegistrationService srs = new SysnetRegistrationService(RegistrationUtil.getServiceTagRegistry());
        if (srs.isRegistrationEnabled()) {
            final Timer registrationTimer = new Timer("registration", true);
            TimerTask registrationTask = new TimerTask(){

                public void run() {
                    try {
                        srs.transferEligibleServiceTagsToSysNet();
                        registrationTimer.cancel();
                    }
                    catch (RegistrationException e) {
                        TransferService.this.logger.info(e.getMessage());
                    }
                }
            };
            registrationTimer.schedule(registrationTask, 0L, TIMER_INTERVAL);
        }
    }
}

