/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl.environment;

import com.sun.enterprise.registration.impl.environment.SystemEnvironment;
import java.util.HashSet;

class LinuxSystemEnvironment
extends SystemEnvironment {
    private String dmiInfo = null;
    private String kstatCpuInfo = null;
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;
    private static final int MODEL = 4;

    LinuxSystemEnvironment() {
        this.setHostId(this.getLinuxHostId());
        this.setSystemModel(this.getLinuxModel());
        this.setSystemManufacturer(this.getLinuxSystemManufacturer());
        this.setCpuManufacturer(this.getLinuxCpuManufacturer());
        this.setSerialNumber(this.getLinuxSN());
        this.setPhysMem(this.getLinuxPhysMem());
        this.setSockets(this.getLinuxSockets());
        this.setCores(this.getLinuxCores());
        this.setVirtCpus(this.getLinuxVirtCpus());
        this.setCpuName(this.getLinuxCpuName());
        this.setClockRate(this.getLinuxClockRate());
    }

    private String getLinuxHostId() {
        String output = this.getCommandOutput("/usr/bin/hostid");
        if (output.startsWith("0x")) {
            output = output.substring(2);
        }
        return output;
    }

    private String getLinuxCpuManufacturer() {
        String tmp = this.getLinuxPSNInfo(3);
        if (tmp.length() > 0) {
            return tmp;
        }
        String contents = this.getFileContent("/proc/cpuinfo");
        for (String line : contents.split("\n")) {
            String[] ss;
            if (!line.contains("vendor_id") || (ss = line.split(":", 2)).length <= 1) continue;
            return ss[1].trim();
        }
        return this.getLinuxDMIInfo("dmi type 4", "manufacturer");
    }

    private String getLinuxModel() {
        String tmp = this.getLinuxPSNInfo(4);
        if (tmp.length() > 0) {
            return tmp + "::" + this.getCommandOutput("/bin/uname", "-v");
        }
        tmp = this.getLinuxDMIInfo("dmi type 1", "product name");
        if (tmp.length() > 0) {
            return tmp + "::" + this.getCommandOutput("/bin/uname", "-v");
        }
        return this.getCommandOutput("/bin/uname", "-i") + "::" + this.getCommandOutput("/bin/uname", "-v");
    }

    private String getLinuxSystemManufacturer() {
        String tmp = this.getLinuxPSNInfo(2);
        if (tmp.length() > 0) {
            return tmp;
        }
        return this.getLinuxDMIInfo("dmi type 1", "manufacturer");
    }

    private String getLinuxSN() {
        String tmp = this.getLinuxPSNInfo(1);
        if (tmp.length() > 0) {
            return tmp;
        }
        return this.getLinuxDMIInfo("dmi type 1", "serial number");
    }

    private String getLinuxPSNInfo(int target) {
        String contents = this.getFileContent("/var/run/psn");
        String[] ss = contents.split("\n");
        if (target <= ss.length) {
            return ss[target - 1];
        }
        return "";
    }

    private synchronized String getLinuxDMIInfo(String dmiType, String target) {
        if (this.dmiInfo == null) {
            Thread dmidecodeThread = new Thread(){

                public void run() {
                    LinuxSystemEnvironment.this.dmiInfo = LinuxSystemEnvironment.this.getCommandOutput("/usr/sbin/dmidecode");
                }
            };
            dmidecodeThread.start();
            try {
                dmidecodeThread.join(3000L);
                if (dmidecodeThread.isAlive()) {
                    dmidecodeThread.interrupt();
                    this.dmiInfo = "";
                }
            }
            catch (InterruptedException ie) {
                dmidecodeThread.interrupt();
            }
        }
        if (this.dmiInfo.length() == 0) {
            return "";
        }
        boolean dmiFlag = false;
        for (String s : this.dmiInfo.split("\n")) {
            String line = s.toLowerCase();
            if (dmiFlag) {
                if (!line.contains(target)) continue;
                String key = target + ":";
                int indx = line.indexOf(key) + key.length();
                if (line.contains(key) && indx < line.length()) {
                    return line.substring(indx).trim();
                }
                String[] ss = line.split(":");
                return ss[ss.length - 1];
            }
            if (!line.contains(dmiType)) continue;
            dmiFlag = true;
        }
        return "";
    }

    private String getLinuxClockRate() {
        String contents = this.getFileContent("/proc/cpuinfo");
        String token = "cpu MHz";
        for (String line : contents.split("\n")) {
            String[] key;
            if (!line.contains(token) || (key = line.split(":", 2)).length <= 1) continue;
            return key[1].trim();
        }
        return "";
    }

    private String getLinuxCpuName() {
        String contents = this.getFileContent("/proc/cpuinfo");
        String token = "model name";
        for (String line : contents.split("\n")) {
            String[] key;
            if (!line.contains(token) || (key = line.split(":", 2)).length <= 1) continue;
            return key[1].trim();
        }
        return "";
    }

    private String getLinuxVirtCpus() {
        HashSet<String> set = new HashSet<String>();
        String contents = this.getFileContent("/proc/cpuinfo");
        String token = "processor";
        for (String line : contents.split("\n")) {
            String[] key;
            if (!line.contains(token) || (key = line.split(":", 2)).length <= 1) continue;
            set.add(key[1].trim());
        }
        return "" + set.size();
    }

    private String getLinuxCores() {
        HashSet<String> set = new HashSet<String>();
        String contents = this.getFileContent("/proc/cpuinfo");
        String token = "core id";
        for (String line : contents.split("\n")) {
            String[] key;
            if (!line.contains(token) || (key = line.split(":", 2)).length <= 1) continue;
            set.add(key[1].trim());
        }
        if (set.size() == 0) {
            return "1";
        }
        return "" + set.size();
    }

    private String getLinuxPhysMem() {
        String contents = this.getFileContent("/proc/meminfo");
        for (String line : contents.split("\n")) {
            String[] total;
            if (!line.contains("MemTotal") || (total = line.split(":", 2)).length <= 1) continue;
            String[] mem = total[1].trim().split(" ");
            if (mem.length >= 1) {
                return mem[0].trim();
            }
            return total[1].trim();
        }
        return "0";
    }

    private String getLinuxSockets() {
        HashSet<String> physIdSet = new HashSet<String>();
        HashSet<String> procSet = new HashSet<String>();
        String contents = this.getFileContent("/proc/cpuinfo");
        String physIdToken = "physical id";
        String procToken = "processor";
        for (String line : contents.split("\n")) {
            String[] key;
            if (line.contains(physIdToken) && (key = line.split(":", 2)).length > 1) {
                physIdSet.add(key[1].trim());
            }
            if (!line.contains(procToken) || (key = line.split(":", 2)).length <= 1) continue;
            procSet.add(key[1].trim());
        }
        if (physIdSet.size() != 0) {
            return "" + physIdSet.size();
        }
        return "" + procSet.size();
    }
}

