/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.impl.environment.XMLUtil;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SvcTag
implements Comparable<SvcTag> {
    public static final String REGISTERED = "REGISTERED";
    public static final String UNREGISTERED = "UNREGISTERED";
    public static final String UNINSTALLED = "UNINSTALLED";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String MATCHED_DOMAINS = "MATCHED_DOMAINS";
    public static final String MISMATCHED_DOMAINS = "MISMATCHED_DOMAINS";
    private String productName;
    private String version;
    private String vendor;
    private String instanceURN;
    private String receivedIPAddress;
    private Date receivedTimestamp;
    private String userID;
    private String agentURN;
    private String productURN;
    private String status;
    private String subStatus;
    private String customerAssetTag;
    private Date timestamp;
    private String source;
    private String container;
    private int domainID;
    private String domainName;
    private int[] channelInstanceIDs;
    private String productDefinedInstID;
    private String productParentURN;
    private String productParent;
    private String agentVersion;
    private String helperVersion;
    private String registrationClientURN;

    public SvcTag(String instanceURN) {
        this.instanceURN = instanceURN;
    }

    public static SvcTag getNew(String instanceURN) {
        return new SvcTag(instanceURN);
    }

    public static SvcTag getExisting(String instanceURN) {
        throw new RuntimeException("TODO: Implement");
    }

    public void setDomainId(int domainID) {
        this.domainID = domainID;
    }

    public void setChannelInstanceIDs(int[] channelInstanceIDs) {
        this.channelInstanceIDs = channelInstanceIDs;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setInstanceURN(String instanceURN) {
        this.instanceURN = instanceURN;
    }

    public void setReceivedIPAddress(String receivedIPAddress) {
        this.receivedIPAddress = receivedIPAddress;
    }

    public void setReceivedTimestamp(Date receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setAgentURN(String agentURN) {
        this.agentURN = agentURN;
    }

    public void setProductURN(String productURN) {
        this.productURN = productURN;
    }

    public void setSubStatus(String subStatus) {
        this.subStatus = subStatus;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setHelperVersion(String helperVersion) {
        this.helperVersion = helperVersion;
    }

    public void setRegistrationClientURN(String registrationClientURN) {
        this.registrationClientURN = registrationClientURN;
        if (this.registrationClientURN != null && this.registrationClientURN.length() > 64) {
            this.registrationClientURN = this.registrationClientURN.substring(0, 64);
        }
    }

    public void setCustomerAssetTag(String customerAssetTag) {
        this.customerAssetTag = customerAssetTag;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getHelperVersion() {
        return this.helperVersion;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public int[] getChannelInstanceIDs() {
        return this.channelInstanceIDs;
    }

    public int getDomainId() {
        return this.domainID;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public String getSource() {
        return this.source;
    }

    public String getProductDefinedInstID() {
        return this.productDefinedInstID;
    }

    public void setProductDefinedInstID(String s) {
        this.productDefinedInstID = s;
    }

    public void setProductVersion(String s) {
        this.version = s;
    }

    public void setProductVendor(String s) {
        this.vendor = s;
    }

    public String getProductVendor() {
        return this.vendor;
    }

    public String getProductVersion() {
        return this.version;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getRegistrationClientURN() {
        return this.registrationClientURN;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String s) {
        this.container = s;
    }

    public String getProductParentURN() {
        return this.productParentURN;
    }

    public void setProductParentURN(String s) {
        this.productParentURN = s;
    }

    public void setState(Element e) {
        if (!this.instanceURN.equals(XMLUtil.getRequiredTextValue(e, "instance_urn"))) {
            String msg = String.format("instance_urns do not match (%s != %s)", this.instanceURN, XMLUtil.getRequiredTextValue(e, "instance_urn"));
            throw new RuntimeException(msg);
        }
        this.productName = XMLUtil.getRequiredTextValue(e, "product_name");
        this.version = XMLUtil.getOptionalTextValue(e, "product_version");
        if (this.version == null || this.version.equals("null")) {
            this.version = "";
        }
        this.vendor = XMLUtil.getOptionalTextValue(e, "product_vendor");
        if (this.vendor == null || this.vendor.equals("null")) {
            this.vendor = "";
        }
        this.userID = XMLUtil.getOptionalTextValue(e, "sun_user_id");
        if (this.userID == null || this.userID.equals("null")) {
            this.userID = "";
        }
        this.agentURN = XMLUtil.getOptionalTextValue(e, "agent_urn");
        if (this.agentURN == null || this.agentURN.equals("null")) {
            this.agentURN = "";
        }
        this.productURN = XMLUtil.getRequiredTextValue(e, "product_urn");
        this.source = XMLUtil.getOptionalTextValue(e, "source");
        if (this.source == null || this.source.equals("null")) {
            this.source = "";
        }
        this.receivedIPAddress = XMLUtil.getOptionalTextValue(e, "received_ip_address");
        if (this.receivedIPAddress != null && (this.receivedIPAddress.trim().equals("null") || this.receivedIPAddress.trim().equals(""))) {
            this.receivedIPAddress = null;
        }
        this.customerAssetTag = XMLUtil.getOptionalTextValue(e, "customer_asset_tag");
        if (this.customerAssetTag == null || this.customerAssetTag.equals("null")) {
            this.customerAssetTag = "";
        }
        this.container = XMLUtil.getRequiredTextValue(e, "container");
        this.status = XMLUtil.getOptionalTextValue(e, "status");
        if (this.status == null || this.status.equals("null") || this.status.trim().equals("")) {
            this.status = UNKNOWN;
        }
        this.subStatus = XMLUtil.getOptionalTextValue(e, "sub_status");
        if (this.subStatus == null || this.subStatus.equals("null") || this.subStatus.trim().equals("")) {
            this.subStatus = "";
        }
        this.productDefinedInstID = XMLUtil.getOptionalTextValue(e, "product_defined_inst_id");
        if (this.productDefinedInstID == null || this.productDefinedInstID.equals("null") || this.productDefinedInstID.trim().equals("")) {
            this.productDefinedInstID = "";
        }
        try {
            this.domainID = Integer.parseInt(XMLUtil.getOptionalTextValue(e, "group_id"));
        }
        catch (NumberFormatException nfe) {
            this.domainID = -1;
        }
        HashSet<Integer> set = new HashSet<Integer>();
        List<String> list = XMLUtil.getOptionalTextValues(e, "channel_instance_id");
        if (list != null) {
            for (String s : list) {
                try {
                    set.add(Integer.parseInt(s));
                }
                catch (NumberFormatException nfe) {}
            }
        }
        this.channelInstanceIDs = new int[set.size()];
        int index = 0;
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            this.channelInstanceIDs[index++] = id;
        }
        this.domainName = XMLUtil.getOptionalTextValue(e, "group_name");
        if (this.domainName == null || this.domainName.equals("null")) {
            this.domainName = "";
        }
        this.agentVersion = XMLUtil.getOptionalTextValue(e, "agent_version");
        if (this.agentVersion == null || this.agentVersion.equals("null")) {
            this.agentVersion = "";
        }
        this.helperVersion = XMLUtil.getOptionalTextValue(e, "helper_version");
        if (this.helperVersion == null || this.helperVersion.equals("null")) {
            this.helperVersion = "";
        }
        this.registrationClientURN = XMLUtil.getOptionalTextValue(e, "registration_client_urn");
        if (this.registrationClientURN == null || this.registrationClientURN.equals("null")) {
            this.registrationClientURN = "";
        }
        if (this.registrationClientURN != null && this.registrationClientURN.length() > 64) {
            this.registrationClientURN = this.registrationClientURN.substring(0, 64);
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            this.timestamp = df.parse(XMLUtil.getRequiredTextValue(e, "timestamp"));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInstanceURN() {
        return this.instanceURN;
    }

    public String getReceivedIPAddress() {
        return this.receivedIPAddress;
    }

    public Date getReceivedTimestamp() {
        if (this.receivedTimestamp == null) {
            this.receivedTimestamp = new Date();
        }
        return (Date)this.receivedTimestamp.clone();
    }

    public String getUserID() {
        return this.userID;
    }

    public String getProductURN() {
        return this.productURN;
    }

    public String getAgentURN() {
        return this.agentURN;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCustomerAssetTag() {
        return this.customerAssetTag;
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public String getTimestampString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        return df.format(this.timestamp);
    }

    public Element toXMLElement() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<st1:request xmlns:st1=\"http://www.sun.com/stv1/svctag\">\n").append(this.toXMLString()).append("</st1:request>\n");
        InputSource is = new InputSource(new StringReader(sb.toString()));
        Document doc = builder.parse(is);
        return doc.getDocumentElement();
    }

    public String toXMLString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("<service_tag>\n", new Object[0]);
        fmt.format("  <instance_urn>%s</instance_urn>\n", this.instanceURN);
        fmt.format("  <sun_user_id>%s</sun_user_id>\n", this.encode(this.userID));
        fmt.format("  <agent_urn>%s</agent_urn>\n", this.agentURN);
        fmt.format("  <product_name>%s</product_name>\n", this.encode(this.productName));
        fmt.format("  <product_version>%s</product_version>\n", this.encode(this.version));
        fmt.format("  <product_vendor>%s</product_vendor>\n", this.encode(this.vendor));
        fmt.format("  <product_urn>%s</product_urn>\n", this.productURN);
        fmt.format("  <product_parent_urn>%s</product_parent_urn>\n", this.productParentURN);
        fmt.format("  <product_parent>%s</product_parent>\n", this.encode(this.productParent));
        fmt.format("  <product_defined_inst_id>%s</product_defined_inst_id>\n", this.encode(this.productDefinedInstID));
        fmt.format("  <status>%s</status>\n", this.encode(this.status));
        if (this.subStatus != null) {
            fmt.format("  <sub_status>%s</sub_status>\n", this.encode(this.subStatus));
        }
        if (this.receivedIPAddress != null) {
            fmt.format("  <received_ip_address>%s</received_ip_address>\n", this.receivedIPAddress);
        }
        fmt.format("  <timestamp>%s</timestamp>\n", this.getTimestampString());
        fmt.format("  <customer_asset_tag>%s</customer_asset_tag>\n", this.encode(this.customerAssetTag));
        if (this.domainName != null) {
            fmt.format("  <group_name>%s</group_name>\n", this.encode(this.domainName));
        }
        fmt.format("  <group_id>%d</group_id>\n", this.domainID);
        if (this.channelInstanceIDs != null) {
            for (int i = 0; i < this.channelInstanceIDs.length; ++i) {
                fmt.format("  <channel_instance_id>%d</channel_instance_id>\n", this.channelInstanceIDs[i]);
            }
        }
        fmt.format("  <container>%s</container>\n", this.encode(this.container));
        fmt.format("  <source>%s</source>\n", this.encode(this.source));
        if (this.agentVersion != null) {
            fmt.format("  <agent_version>%s</agent_version>\n", this.agentVersion);
        }
        if (this.helperVersion != null) {
            fmt.format("  <helper_version>%s</helper_version>\n", this.helperVersion);
        }
        if (this.registrationClientURN != null) {
            fmt.format("  <registration_client_urn>%s</registration_client_urn>\n", this.registrationClientURN);
        }
        fmt.format("</service_tag>\n", new Object[0]);
        return sb.toString();
    }

    @Override
    public int compareTo(SvcTag svcTag) {
        return this.getProductName().compareTo(svcTag.getProductName());
    }

    public String encode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }
}

