/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationDescriptor;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.impl.RegistrationLogger;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.SysnetTransferManager;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SysnetRegistrationService
implements RegistrationService {
    private final File localRepositoryFile;
    private static final String AIX = "AIX";
    private static final Logger logger = RegistrationLogger.getLogger();

    public SysnetRegistrationService(File localRepositoryFile) {
        this.localRepositoryFile = localRepositoryFile;
    }

    public boolean isRegistrationEnabled() {
        if (AIX.equalsIgnoreCase(System.getProperty("os.name"))) {
            return false;
        }
        return this.localRepositoryFile.canWrite();
    }

    public void register(RegistrationAccount account) throws RegistrationException, ConnectException, UnknownHostException {
        throw new RuntimeException("Not supported");
    }

    public void createRegistrationAccount(RegistrationAccount soa) throws RegistrationException {
        throw new RuntimeException("Not supported");
    }

    public List getRegistrationDescriptors() throws RegistrationException {
        RepositoryManager rm = this.getRepositoryManager();
        rm.updateRuntimeValues();
        return rm.getServiceTags();
    }

    public List getRegistrationDescriptors(String productURN) throws RegistrationException {
        List st1 = this.getRegistrationDescriptors();
        ArrayList<ServiceTag> st2 = new ArrayList<ServiceTag>();
        for (int i = 0; i < st1.size(); ++i) {
            ServiceTag st = (ServiceTag)st1.get(i);
            if (!st.getProductURN().equals(productURN)) continue;
            st2.add(st);
        }
        return st2;
    }

    public List getRegistrationDescriptors(RegistrationDescriptor.RegistrationStatus status) throws RegistrationException {
        List st1 = this.getRegistrationDescriptors();
        ArrayList<ServiceTag> st2 = new ArrayList<ServiceTag>();
        RepositoryManager rm = this.getRepositoryManager();
        for (int i = 0; i < st1.size(); ++i) {
            ServiceTag st = (ServiceTag)st1.get(i);
            if (!rm.getRegistrationStatus(st).equals((Object)status)) continue;
            st2.add(st);
        }
        return st2;
    }

    public RegistrationService.RegistrationReminder getRegistrationReminder() throws RegistrationException {
        return this.getRepositoryManager().getRegistrationReminder();
    }

    public void setRegistrationReminder(RegistrationService.RegistrationReminder reminder) throws RegistrationException {
        this.getRepositoryManager().setRegistrationReminder(reminder);
    }

    public RegistrationService.RegistrationStatus getRegistrationStatus() throws RegistrationException {
        return this.getRepositoryManager().getRegistrationStatus();
    }

    public void setRegistrationStatus(RegistrationService.RegistrationStatus status) throws RegistrationException {
        this.getRepositoryManager().setRegistrationStatus(status);
    }

    public void transferEligibleServiceTagsToSysNet() throws RegistrationException {
        SysnetTransferManager transferManager = new SysnetTransferManager(this.localRepositoryFile);
        transferManager.transferServiceTags();
    }

    private RepositoryManager getRepositoryManager() throws RegistrationException {
        return new RepositoryManager(this.localRepositoryFile);
    }
}

