/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Commands {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager stringManager = StringManager.getManager(Commands.class);

    public static int startDomain(String domainName, CommonInfoModel commonInfo) {
        Credentials c = commonInfo.getSource().getDomainCredentials();
        String adminUser = c.getAdminUserName();
        ArrayList<String> tmpC = new ArrayList<String>();
        tmpC.add("start-domain");
        tmpC.add("--domaindir");
        tmpC.add(commonInfo.getTarget().getInstallDir());
        if (adminUser != null && adminUser.length() > 0) {
            tmpC.add("--user");
            tmpC.add(adminUser);
            String adminPassword = c.getAdminPassword();
            if (adminPassword != null && adminPassword.length() > 0) {
                tmpC.add("--passwordfile ");
                tmpC.add(c.getPasswordFile());
            }
        }
        tmpC.add(domainName);
        String[] command = new String[tmpC.size()];
        command = tmpC.toArray(command);
        return Commands.executeCommand(command);
    }

    public static int stopDomain(String domainName, CommonInfoModel commonInfo) {
        String[] command = new String[]{"stop-domain", "--domaindir", commonInfo.getTarget().getInstallDir(), domainName};
        return Commands.executeCommand(command);
    }

    public static int executeCommand(String[] commandStrings) {
        int exitValue = 0;
        try {
            StringBuffer commandOneString = new StringBuffer();
            for (int i = 0; i < commandStrings.length; ++i) {
                commandOneString.append(commandStrings[i]).append(" ");
            }
            InputsAndOutputs io = InputsAndOutputs.getInstance();
            PipedOutputStream pos = new PipedOutputStream();
            io.setErrorOutput((OutputStream)pos);
            io.setUserOutput((OutputStream)pos);
            CommandOutputReader cor = new CommandOutputReader(pos);
            cor.start();
            logger.info(stringManager.getString("commands.executingCommandMsg") + commandOneString);
            pos.flush();
            return exitValue;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            logger.warning(stringManager.getString("upgrade.common.general_exception") + (t == null ? e.getMessage() : t.getMessage()));
            return exitValue;
        }
    }

    static class CommandOutputReader
    extends Thread {
        PipedInputStream pis = new PipedInputStream();

        public CommandOutputReader(PipedOutputStream pout) throws IOException {
            this.pis.connect(pout);
        }

        public void run() {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(this.pis));
            try {
                String s;
                while ((s = buffReader.readLine()) != null) {
                    logger.info(s);
                }
                buffReader.close();
            }
            catch (Exception ioe) {
                try {
                    buffReader.close();
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }

        protected void finalize() throws Throwable {
            this.pis.close();
        }
    }
}

