/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Commands {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager stringManager = StringManager.getManager(Commands.class);

    public static int startDomain(String domainName, CommonInfoModel commonInfo) {
        Credentials c = commonInfo.getSource().getDomainCredentials();
        String adminUser = c.getAdminUserName();
        String installRoot = System.getProperty("com.sun.aas.domainRoot");
        File installRootF = new File(installRoot);
        File asadminF = new File(installRootF.getParentFile(), "bin/asadmin");
        String asadminScript = asadminF.getAbsolutePath();
        try {
            asadminScript = asadminF.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        String ext = "";
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") != -1) {
            ext = ".bat";
        }
        ArrayList<String> tmpC = new ArrayList<String>();
        tmpC.add(asadminScript + ext);
        tmpC.add("start-domain");
        tmpC.add("--upgrade");
        tmpC.add("--domaindir");
        tmpC.add(commonInfo.getTarget().getInstallDir());
        if (adminUser != null && adminUser.length() > 0) {
            tmpC.add("--user");
            tmpC.add(adminUser);
            String adminPassword = c.getAdminPassword();
            if (adminPassword != null && adminPassword.length() > 0) {
                tmpC.add("--passwordfile ");
                tmpC.add(c.getPasswordFile());
            }
        }
        tmpC.add(domainName);
        String[] command = new String[tmpC.size()];
        command = tmpC.toArray(command);
        return Commands.executeCommand(command);
    }

    private static int executeCommand(String[] commandStrings) {
        int exitValue = 0;
        StringBuffer commandOneString = new StringBuffer();
        for (int i = 0; i < commandStrings.length; ++i) {
            commandOneString.append(commandStrings[i]).append(" ");
        }
        logger.info(stringManager.getString("commands.executingCommandMsg") + commandOneString);
        try {
            Process asadminProcess = Runtime.getRuntime().exec(commandOneString.toString());
            BufferedReader pInReader = new BufferedReader(new InputStreamReader(asadminProcess.getInputStream()));
            BufferedReader eInReader = new BufferedReader(new InputStreamReader(asadminProcess.getErrorStream()));
            String inLine = null;
            String eLine = null;
            while ((eLine = eInReader.readLine()) != null && (inLine = pInReader.readLine()) != null) {
                if (eLine != null) {
                    logger.log(Level.INFO, eLine);
                    ++exitValue;
                }
                if (inLine == null) continue;
                logger.log(Level.INFO, inLine);
            }
            asadminProcess.destroy();
            pInReader.close();
            eInReader.close();
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            logger.warning(stringManager.getString("upgrade.common.general_exception") + (t == null ? e.getMessage() : t.getMessage()));
        }
        return exitValue;
    }
}

