/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DirectoryMover;
import com.sun.enterprise.tools.upgrade.common.InputsAndOutputs;
import com.sun.enterprise.tools.upgrade.common.InteractiveInput;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_adminpassword;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_adminuser;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_masterpassword;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_source;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_target;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveInputImpl
implements DirectoryMover,
InteractiveInput {
    private static final Logger logger = LogService.getLogger();
    private Map<String, ArgumentHandler> inputMap;
    private static final StringManager sm = StringManager.getManager(InteractiveInputImpl.class);
    private static final CommonInfoModel commonInfoModel = CommonInfoModel.getInstance();

    @Override
    public void processArguments(ArrayList<ArgumentHandler> aList) {
        int cnt = aList.size();
        this.inputMap = new HashMap<String, ArgumentHandler>();
        for (int i = 0; i < cnt; ++i) {
            ArgumentHandler tmpAh = aList.get(i);
            this.inputMap.put(tmpAh.getCmd(), tmpAh);
        }
        try {
            this.sourcePrompt();
            this.targetPrompt();
            if (!CommonInfoModel.getInstance().isUpgradeSupported()) {
                System.exit(1);
            }
            this.adminPrompt();
            this.adminPasswordPrompt();
            this.masterPasswordPrompt();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
        }
    }

    private String getResponse() throws IOException {
        String response = null;
        byte[] b = new byte[1024];
        int c = System.in.read(b);
        if (c == -1) {
            System.exit(1);
        }
        response = new String(b, 0, c);
        return response.trim();
    }

    private void sourcePrompt() throws IOException {
        ArgumentHandler tmpA = this.inputMap.get("s");
        if (tmpA == null) {
            tmpA = this.inputMap.get("source");
        }
        if (tmpA == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.Source_input"));
            String source = this.getResponse();
            tmpA = new ARG_source();
            tmpA.setRawParameters(source);
            this.inputMap.put("source", tmpA);
        }
        if (tmpA.isValidParameter()) {
            tmpA.exec();
        } else {
            logger.severe(sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
            this.inputMap.remove("s");
            this.inputMap.remove("source");
            this.sourcePrompt();
        }
    }

    private void targetPrompt() throws IOException {
        ArgumentHandler tmpA = this.inputMap.get("t");
        if (tmpA == null) {
            tmpA = this.inputMap.get("target");
        }
        if (tmpA == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_input"));
            String target = this.getResponse();
            tmpA = new ARG_target();
            tmpA.setRawParameters(target);
            this.inputMap.put("target", tmpA);
        }
        tmpA.getCommonInfo().getTarget().setDirectoryMover(this);
        if (tmpA.isValidParameter()) {
            tmpA.exec();
        } else {
            logger.severe(sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
            this.inputMap.remove("t");
            this.inputMap.remove("target");
            this.targetPrompt();
        }
    }

    private void adminPrompt() throws IOException {
        ArgumentHandler tmpA = this.inputMap.get("a");
        if (tmpA == null) {
            tmpA = this.inputMap.get("adminuser");
        }
        if (tmpA == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.adminuser_input"));
            String admiuser = this.getResponse();
            tmpA = new ARG_adminuser();
            tmpA.setRawParameters(admiuser);
            this.inputMap.put("adminuser", tmpA);
        }
        tmpA.exec();
    }

    private void adminPasswordPrompt() throws IOException {
        ArgumentHandler tmpA = this.inputMap.get("w");
        if (tmpA == null) {
            tmpA = this.inputMap.get("adminpassword");
        }
        if (tmpA == null) {
            String adminPassword = this.getPasswordResponse(sm.getString("enterprise.tools.upgrade.cli.adminpassword_input"));
            tmpA = new ARG_adminpassword();
            tmpA.setRawParameters(adminPassword);
            this.inputMap.put("adminpassword", tmpA);
        }
        tmpA.exec();
    }

    private void masterPasswordPrompt() throws IOException {
        ArgumentHandler tmpA = this.inputMap.get("m");
        if (tmpA == null) {
            tmpA = this.inputMap.get("masterpassword");
        }
        if (tmpA == null) {
            String password = this.getPasswordResponse(sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"));
            tmpA = new ARG_masterpassword();
            tmpA.setRawParameters(password);
            this.inputMap.put("masterpassword", tmpA);
        }
        tmpA.exec();
    }

    private String getPasswordResponse(String prompt) {
        String optionValue;
        try {
            InputsAndOutputs.getInstance().getUserOutput().print(prompt);
            InputsAndOutputs.getInstance().getUserOutput().flush();
            optionValue = new CliUtil().getPassword();
        }
        catch (NoClassDefFoundError e) {
            optionValue = this.readInput();
        }
        catch (UnsatisfiedLinkError e) {
            optionValue = this.readInput();
        }
        catch (Exception e) {
            optionValue = null;
        }
        return optionValue;
    }

    private String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().readLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void helpUsage(String str) {
        System.out.println("\n" + str + "\n");
        this.helpUsage();
    }

    public void helpUsage() {
        this.helpUsage(0);
    }

    public void helpUsage(int exitCode) {
        System.out.println("(FIX THIS) InteractiveInputImpl:helpUsage:exitcode: " + exitCode);
    }

    @Override
    public boolean moveDirectory(File dir) {
        try {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.move_dir", (Object)dir.getName()));
            String response = this.getResponse();
            String yesOption = sm.getString("enterprise.tools.upgrade.cli.yes_option");
            boolean move = yesOption.equalsIgnoreCase(response);
            if (move) {
                UpgradeUtils.getUpgradeUtils(commonInfoModel).rename(dir);
            }
            return move;
        }
        catch (IOException ioe) {
            logger.warning(ioe.getLocalizedMessage());
            return false;
        }
    }
}

