/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainsProcessor {
    private CommonInfoModel commonInfo;
    private static final StringManager stringManager = StringManager.getManager(DomainsProcessor.class);
    private static final Logger logger = LogService.getLogger();

    public DomainsProcessor(CommonInfoModel ci) {
        this.commonInfo = ci;
    }

    public int startDomain(String domainName) throws HarnessException {
        return Commands.startDomain(domainName, this.commonInfo);
    }

    public void copyUserLibFiles() {
        logger.info(stringManager.getString("upgrade.common.start_copy_user_libs"));
        String dirName = this.commonInfo.getSource().getInstallDir();
        File sLibDir = this.findLibDir(dirName, true);
        if (sLibDir == null) {
            logger.warning(stringManager.getString("upgrade.common.src_lib_dir_not_found", (Object)dirName));
            this.logUserMustCopyFiles();
            return;
        }
        dirName = this.commonInfo.getTarget().getInstallDir();
        File tLibDir = this.findLibDir(dirName, false);
        if (tLibDir == null) {
            logger.warning(stringManager.getString("upgrade.common.trg_lib_dir_not_found", (Object)(tLibDir + "/../lib")));
            this.logUserMustCopyFiles();
            return;
        }
        if (sLibDir.equals(tLibDir)) {
            logger.info(stringManager.getString("upgrade.common.sourceIsTarget"));
            return;
        }
        UpgradeUtils u = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        u.copyUserLibFiles(sLibDir, tLibDir);
        logger.info(stringManager.getString("upgrade.common.finished_copy_user_libs"));
    }

    private void logUserMustCopyFiles() {
        logger.warning(stringManager.getString("upgrade.common.warning_user_must_copy_file"));
    }

    private File findLibDir(String source, boolean isDomain) {
        StringBuilder path = new StringBuilder();
        path.append(source);
        if (isDomain) {
            path.append(File.separatorChar);
            path.append("..");
        }
        path.append(File.separatorChar);
        path.append("..");
        path.append(File.separatorChar);
        path.append("lib");
        String fullPath = path.toString();
        File retFile = new File(fullPath);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Source path is %s", source));
            logger.fine(String.format("isDomain=%s", isDomain));
            logger.fine(String.format("built lib path is %s", fullPath));
        }
        if (retFile.exists() && retFile.isDirectory()) {
            try {
                return retFile.getCanonicalFile();
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, "Can't create canonical file from " + retFile.getPath(), ioe);
                return null;
            }
        }
        return null;
    }
}

