/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.UpgradeToolMain;
import com.sun.enterprise.tools.upgrade.gui.MainFrame;
import com.sun.enterprise.tools.upgrade.gui.ProgressPanel;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class UpgradeWorker
extends SwingWorker<Void, Void> {
    private final MainFrame mainFrame;
    private final ProgressPanel progressPanel;
    private final UpgradeToolMain upgradeToolMain;
    private static final Logger systemLogger = LogService.getLogger();

    public UpgradeWorker(MainFrame mainFrame, UpgradeToolMain upgradeToolMain) {
        this.mainFrame = mainFrame;
        this.upgradeToolMain = upgradeToolMain;
        this.progressPanel = mainFrame.getProgressPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        GUILogHandler handler = new GUILogHandler(this.progressPanel);
        Throwable unexpected = null;
        try {
            systemLogger.addHandler(handler);
            this.upgradeToolMain.performUpgrade();
        }
        catch (Throwable t) {
            System.err.println(t.getLocalizedMessage());
            unexpected = t;
        }
        finally {
            systemLogger.removeHandler(handler);
            if (unexpected != null) {
                systemLogger.log(Level.SEVERE, "Problem in swing worker thread", unexpected);
            }
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.mainFrame.done();
    }

    private class GUILogHandler
    extends Handler {
        private final ProgressPanel progressPanel;

        private GUILogHandler(ProgressPanel progressPanel) {
            this.progressPanel = progressPanel;
        }

        @Override
        public void publish(LogRecord record) {
            this.progressPanel.appendResultString(record.getMessage(), record.getLevel());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

