/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class HomeInterfaceCreateMethodExceptionMatch
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean foundAtLeastOneCreate = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            if ((descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) && (descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName()))) {
                if (!this.implementsEndpoints(descriptor)) {
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.failedhome", "Ejb [ {0} ] does not have local or remote Home interfaces", new Object[]{descriptor.getEjbClassName()}));
                    this.result.setStatus(1);
                    return this.result;
                }
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                this.result.setStatus(3);
                return this.result;
            }
            boolean oneFailed = false;
            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String local, EjbSessionDescriptor descriptor) {
        boolean oneFailed = false;
        int ejbCreateMethodLoopCounter = 0;
        try {
            int i;
            Method[] homeMethods;
            Class<?> c;
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            boolean ejbCreateFound = false;
            boolean exceptionsMatch = false;
            Vector<Method> createMethodSuffix = new Vector<Method>();
            if (home != null) {
                c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
                homeMethods = c.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(homeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (local != null) {
                c = Class.forName(local, false, this.getVerifierContext().getClassLoader());
                homeMethods = c.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(homeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (!this.foundAtLeastOneCreate) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: no create<Method> method exists!", new Object[0]));
                return true;
            }
            Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            block4: do {
                Method[] methods = EJBClass.getDeclaredMethods();
                for (i = 0; i < methods.length; ++i) {
                    ejbCreateFound = false;
                    exceptionsMatch = false;
                    if (!methods[i].getName().startsWith("ejbCreate")) continue;
                    String matchSuffix = methods[i].getName().substring(9);
                    for (int k = 0; k < createMethodSuffix.size(); ++k) {
                        Object[] ejbCreateMethodParameterTypes;
                        Object[] methodParameterTypes;
                        if (!matchSuffix.equals(((Method)createMethodSuffix.elementAt(k)).getName().substring(6)) || !Arrays.equals(methodParameterTypes = ((Method)createMethodSuffix.elementAt(k)).getParameterTypes(), ejbCreateMethodParameterTypes = methods[i].getParameterTypes())) continue;
                        ejbCreateFound = true;
                        Class[] methodExceptionTypes = ((Method)createMethodSuffix.elementAt(k)).getExceptionTypes();
                        Class[] ejbCreateMethodExceptionTypes = methods[i].getExceptionTypes();
                        if (!RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(ejbCreateMethodExceptionTypes, methodExceptionTypes)) continue;
                        exceptionsMatch = true;
                        ejbCreateMethodLoopCounter = k;
                        break;
                    }
                    if (ejbCreateFound && exceptionsMatch) {
                        this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching exceptions was found.", new Object[]{methods[i].getName()}));
                    }
                    if (ejbCreateFound && !exceptionsMatch) {
                        oneFailed = true;
                        this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A corresponding [ {0} ] method was found, but the exceptions defined by method [ {1} ] are not defined within matching create() method.", new Object[]{"ejb" + methods[i].getName().toUpperCase().substring(0, 1) + methods[i].getName().substring(1), "ejb" + methods[i].getName().toUpperCase().substring(0, 1) + methods[i].getName().substring(1)}));
                        continue;
                    }
                    if (ejbCreateFound) continue;
                    oneFailed = true;
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No corresponding ejbCreate method was found."));
                    continue block4;
                }
            } while (!oneFailed && (EJBClass = EJBClass.getSuperclass()) != null && (!ejbCreateFound || !exceptionsMatch));
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home (Remote/Local) interface or Bean class [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

