/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public class FilterMapping
extends WebTest {
    Result result;
    ComponentNameConstructor compName;

    public Result check(WebBundleDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        if (filterEnum.hasMoreElements()) {
            while (filterEnum.hasMoreElements()) {
                ServletFilterDescriptor filter = (ServletFilterDescriptor)filterEnum.nextElement();
                this.hasValidMapping(descriptor, filter.getName());
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All filter mappings are correct"));
        }
        return this.result;
    }

    private void hasValidMapping(WebBundleDescriptor descriptor, String filterName) {
        Enumeration filtermapperEnum = descriptor.getServletFilterMappingDescriptors().elements();
        if (filtermapperEnum.hasMoreElements()) {
            String filterMapping;
            ServletFilterMappingDescriptor filterMapper = null;
            boolean mappingFound = false;
            while (!(mappingFound = filterName.equals(filterMapping = (filterMapper = (ServletFilterMappingDescriptor)filtermapperEnum.nextElement()).getName())) && filtermapperEnum.hasMoreElements()) {
            }
            if (mappingFound) {
                List urlPatterns = filterMapper.getURLPatterns();
                for (String url : urlPatterns) {
                    if (url.startsWith("/") || url.startsWith("/") && url.endsWith("/*") || url.startsWith("*.")) continue;
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Filter Mapping for [ {0} ] has invalid url-mapping [ {1} ] ", new Object[]{filterName, url}));
                }
                List servletsInFilter = filterMapper.getServletNames();
                ArrayList<String> servletsInWAR = new ArrayList<String>();
                if (servletsInFilter.size() > 0) {
                    Set servletDescriptor = descriptor.getServletDescriptors();
                    for (WebComponentDescriptor servlet : servletDescriptor) {
                        servletsInWAR.add(servlet.getCanonicalName());
                    }
                    if (servletsInWAR == null || !servletsInWAR.containsAll(servletsInFilter)) {
                        this.addErrorDetails(this.result, this.compName);
                        this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Filter Mapping for [ {0} ] has invalid servlet-name", new Object[]{filterName}));
                    }
                }
            }
        }
    }
}

