/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;

public class EntityManagerInjection
extends WebTest
implements WebCheck {
    static final String className = EntityManagerInjection.class.getName();

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        this.addWarningDetails(result, this.getVerifierContext().getComponentNameConstructor());
        result.setStatus(0);
        for (EntityManagerReferenceDescriptor emRefDesc : descriptor.getEntityManagerReferenceDescriptors()) {
            Set injectionTargets = emRefDesc.getInjectionTargets();
            if (injectionTargets == null) continue;
            for (InjectionTarget it : injectionTargets) {
                String itClassName = it.getClassName();
                String errMsg = smh.getLocalString(className + ".warning", "Found a persistence unit by name [ {0} ] injected into [ {1} ].", new Object[]{emRefDesc.getUnitName(), itClassName});
                try {
                    Class<?> c = Class.forName(itClassName, false, this.getVerifierContext().getClassLoader());
                    if (!Servlet.class.isAssignableFrom(c)) {
                        result.warning(errMsg);
                        continue;
                    }
                    if (SingleThreadModel.class.isAssignableFrom(c)) continue;
                    result.warning(errMsg);
                }
                catch (Exception ex) {
                    result.warning(errMsg);
                }
            }
        }
        return result;
    }
}

