/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class FilterInitParamName
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        if (filterEnum.hasMoreElements()) {
            while (filterEnum.hasMoreElements()) {
                ServletFilterDescriptor filter = (ServletFilterDescriptor)filterEnum.nextElement();
                HashSet<String> envSet = new HashSet<String>();
                Vector epVector = filter.getInitializationParameters();
                for (int i = 0; i < epVector.size(); ++i) {
                    EnvironmentProperty ep = (EnvironmentProperty)epVector.elementAt(i);
                    String epName = ep.getName();
                    if (epName.length() == 0) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Param name/value entry should of finite length."));
                        continue;
                    }
                    if (!envSet.contains(epName)) {
                        envSet.add(epName);
                        continue;
                    }
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: Duplicate param names are not allowed."));
                }
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All init parameter names are unique"));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no initialization parameters for the filter within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

