/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.EjbClosureCompiler;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class EjbVerifier
extends BaseVerifier {
    private EjbBundleDescriptor ejbd = null;
    private String classPath;
    private boolean isASMode = false;

    public EjbVerifier(VerifierFrameworkContext verifierFrameworkContext, EjbBundleDescriptor ejbd) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.ejbd = ejbd;
        this.isASMode = !verifierFrameworkContext.isPortabilityMode();
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.verifierFrameworkContext.isEjb()) && this.areTestsNotRequired(this.verifierFrameworkContext.isWebServices()) && this.areTestsNotRequired(this.verifierFrameworkContext.isWebServicesClient()) && this.areTestsNotRequired(this.verifierFrameworkContext.isPersistenceUnits())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify((Descriptor)this.ejbd, new EjbCheckMgrImpl(this.verifierFrameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.ejbd;
    }

    protected ClassLoader createClassLoader() throws IOException {
        return this.ejbd.getClassLoader();
    }

    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFilename((String)this.ejbd.getModuleDescriptor().getArchiveUri());
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-ejb-jar.xml", "META-INF/ejb-jar.xml", "META-INF/glassfish-ejb-jar.xml", "META-INF/webservices.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.verifierFrameworkContext.getClassPath());
            return this.classPath;
        }
        if (!this.ejbd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.ejbd.getApplication().getLibraryDirectory();
            if (libdir != null) {
                earCP = this.getLibdirClasspath(ear_uri, libdir) + earCP;
            }
            String module_uri = this.ejbd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert (module.isFile() && !module.isAbsolute());
            File explodedModuleDir = new File(ear_uri, FileUtils.makeFriendlyFilename((String)module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForJar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForJar(module);
        }
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getEJBVersion(this.verifierFrameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.ejbd.getClassLoader() : this.getClassPath();
        EjbClosureCompiler cc = new EjbClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }
}

