/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class WebSecurityRoleName
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int naSr = 0;
            int naAci = 0;
            int noAci = 0;
            int noSc = 0;
            Enumeration e = descriptor.getSecurityConstraints();
            while (e.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e.nextElement();
                AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl)securityConstraintImpl.getAuthorizationConstraint();
                if (aci != null) {
                    ++noAci;
                    if (aci.getSecurityRoles().hasMoreElements()) {
                        Enumeration ee = aci.getSecurityRoles();
                        while (ee.hasMoreElements()) {
                            SecurityRoleDescriptor srd = (SecurityRoleDescriptor)ee.nextElement();
                            String roleName = srd.getName();
                            foundIt = roleName.length() > 0;
                            if (foundIt) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The security role name [ {0} ] found within web application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                                continue;
                            }
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The security role name [ {0} ] not found within web application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                        }
                        continue;
                    }
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Not Applicable: There are no security roles in this security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                    ++naSr;
                    continue;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Not Applicable: There is no authorization constraint in this security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++naAci;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (noSc == naAci || noAci == naSr) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no role-name elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

