/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import java.util.ArrayList;

public class TagNameIsUnique
extends WebTest
implements WebCheck {
    boolean oneFailed = false;

    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        VerifierTestContext context = this.getVerifierContext();
        Result result = this.loadWarFile(descriptor);
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            String[] names;
            TagDescriptor[] tagDesc = tld.getTagDescriptors();
            ArrayList<String> name = new ArrayList<String>();
            for (TagDescriptor td : tagDesc) {
                name.add(td.getTagName());
            }
            if (name == null || this.checkForDuplicateNames(result, compName, names = name.toArray(new String[0]), tld)) continue;
            this.addGoodDetails(result, compName);
            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "All 'name' elements are defined properly under tag element of [ {0} ]", new Object[]{tld.getUri()}));
        }
        if (this.oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }

    public boolean checkForDuplicateNames(Result result, ComponentNameConstructor compName, String[] names, TagLibDescriptor tld) {
        boolean duplicate = false;
        for (int i = 0; i < names.length - 1; ++i) {
            for (int j = i + 1; j < names.length; ++j) {
                duplicate = names[i].trim().equals(names[j]);
                if (!duplicate) continue;
                this.oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "The name element value [ {0} ] under tag element in [ {1} ] is not unique", new Object[]{names[i], tld.getUri()}));
            }
        }
        return this.oneFailed;
    }
}

