/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class AppClientResourceType
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getResourceReferenceDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set resources = descriptor.getResourceReferenceDescriptors();
            Iterator itr = resources.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
                String resType = next.getType();
                this.logger.log(Level.FINE, "servlet resType: " + resType);
                if (resType.equals("javax.sql.DataSource") || resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.jms.ConnectionFactory") || resType.equals("javax.mail.Session") || resType.equals("java.net.URL")) {
                    foundIt = true;
                } else {
                    foundIt = false;
                    String specVerStr = descriptor.getSpecVersion();
                    double specVer = 0.0;
                    specVer = Double.valueOf(specVerStr);
                    if (Double.compare(specVer, 1.4) >= 0) {
                        foundIt = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The resource-type [ {0} ] element specifies the Java class type of the data source within application client [ {1} ]", new Object[]{resType, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The resource-type [ {0} ] element does not specify valid Java class type of the data source within application client [ {1} ]", new Object[]{resType, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no resource-type elements within the application client [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

