/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.webservices;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import java.util.Iterator;

public class WebServiceCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private final String testsListFileName = "TestNamesWebServices.xml";
    private final String sunONETestsListFileName = WebServiceCheckMgrImpl.getSunPrefix().concat("TestNamesWebServices.xml");
    private String moduleName;

    public WebServiceCheckMgrImpl(VerifierFrameworkContext verifierFrameworkContext) {
        this.verifierFrameworkContext = verifierFrameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        WebServicesDescriptor rootDescriptor = (WebServicesDescriptor)descriptor;
        XModuleType moduleType = rootDescriptor.getBundleDescriptor().getModuleType();
        if (moduleType == XModuleType.EJB) {
            this.moduleName = "ejb";
        } else if (moduleType == XModuleType.WAR) {
            this.moduleName = "web";
        }
        for (WebService wsDescriptor : rootDescriptor.getWebServices()) {
            Iterator endPtItr = wsDescriptor.getEndpoints().iterator();
            while (endPtItr.hasNext()) {
                super.check((Descriptor)((WebServiceEndpoint)endPtItr.next()));
            }
        }
    }

    protected String getTestsListFileName() {
        return "TestNamesWebServices.xml";
    }

    protected String getSunONETestsListFileName() {
        return this.sunONETestsListFileName;
    }

    protected String getSchemaVersion(Descriptor descriptor) {
        return ((WebServiceEndpoint)descriptor).getWebService().getWebServicesDescriptor().getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }

    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((WebServiceEndpoint)descriptor).getBundleDescriptor();
    }

    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((WebServiceEndpoint)descriptor);
    }
}

