/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.libvirt.CDRomDisk;
import org.glassfish.virtualization.libvirt.LibVirtGroup;
import org.glassfish.virtualization.libvirt.LibVirtStoragePool;
import org.glassfish.virtualization.libvirt.LibVirtStorageVol;
import org.glassfish.virtualization.libvirt.LibVirtVirtualMachine;
import org.glassfish.virtualization.libvirt.jna.Connect;
import org.glassfish.virtualization.libvirt.jna.Domain;
import org.glassfish.virtualization.os.Disk;
import org.glassfish.virtualization.runtime.LocalMachine;
import org.glassfish.virtualization.runtime.LocalTemplate;
import org.glassfish.virtualization.runtime.RemoteTemplate;
import org.glassfish.virtualization.runtime.VMTemplate;
import org.glassfish.virtualization.runtime.VirtualCluster;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injector;
import org.jvnet.hk2.component.PostConstruct;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtLocalMachine
extends LocalMachine
implements PostConstruct {
    final Map<String, LibVirtVirtualMachine> domains = new HashMap<String, LibVirtVirtualMachine>();
    final Map<String, LibVirtStoragePool> storagePools = new HashMap<String, LibVirtStoragePool>();
    Connect connect;
    @Inject
    Virtualizations virtualizations;
    @Inject
    Habitat habitat;

    public static LibVirtLocalMachine from(Injector injector, LibVirtGroup group, MachineConfig config) {
        return (LibVirtLocalMachine)injector.inject((Object)new LibVirtLocalMachine(injector, group, config));
    }

    protected LibVirtLocalMachine(Injector injector, LibVirtGroup group, MachineConfig config) {
        super(injector, group, config);
    }

    public void postConstruct() {
        this.setState(this.isUp() ? Machine.State.READY : Machine.State.SUSPENDED);
        Virtualization virt = this.group.getConfig().getVirtualization();
        for (Template template : virt.getTemplates()) {
            this.installedTemplates.put(template.getName(), new LocalTemplate(this.virtualizations.getTemplatesLocation(), template));
        }
        if (this.getState().equals((Object)Machine.State.READY)) {
            RuntimeContext.es.submit(new TemplateTask());
        }
    }

    @Override
    public LibVirtStoragePool addStoragePool(String name, long capacity) throws VirtException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<pool type='dir'>\n").append("  <name>").append(name).append("</name>\n").append("  <uuid>").append(UUID.randomUUID()).append("</uuid>\n").append("  <capacity>").append(capacity).append("</capacity>\n").append("  <source>\n").append("  </source>\n").append("  <target>\n").append("    <path>").append(this.getUserHome()).append("/").append(this.config.getDisksLocation()).append("</path>\n").append("    <permissions>\n").append("      <mode>0700</mode>\n").append("      <owner>").append(this.getUser().getUserId()).append("</owner>\n").append("      <group>").append(this.getUser().getUserId()).append("</group>\n").append("    </permissions>\n").append("  </target>\n").append("</pool>");
            LibVirtStoragePool storagePool = new LibVirtStoragePool(this, this.connection().storagePoolCreateXML(sb.toString(), 0));
            this.storagePools.put(name, storagePool);
            return storagePool;
        }
        catch (VirtException e) {
            throw new VirtException(e);
        }
    }

    public String description() {
        StringBuffer sb = new StringBuffer();
        sb.append("Machine ").append(this.getName());
        try {
            this.connection();
            int[] domainIds = this.connect.listDomains();
            if (domainIds == null || domainIds.length == 0) {
                sb.append(" with no virtual machines defined");
            } else {
                sb.append(" with domains : [");
                for (int domainId : domainIds) {
                    Domain testDomain = this.connect.domainLookupByID(domainId);
                    sb.append("[ domain:").append(testDomain.getName()).append(" id ").append(testDomain.getID()).append(" running ").append(testDomain.getOSType()).append(" ]");
                }
                sb.append("]");
            }
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception caught :" + e, e);
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    @Override
    public Iterable<? extends VirtualMachine> getVMs() throws VirtException {
        try {
            this.populate();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
        }
        return this.domains.values();
    }

    @Override
    public Map<String, ? extends StoragePool> getStoragePools() throws VirtException {
        try {
            this.populate();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of storage pools ", e);
        }
        return Collections.unmodifiableMap(this.storagePools);
    }

    @Override
    public VirtualMachine byName(String name) throws VirtException {
        if (!this.domains.containsKey(name)) {
            try {
                this.populate();
            }
            catch (VirtException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            }
        }
        return this.domains.get(name);
    }

    @Override
    public void sleep() throws IOException, InterruptedException {
        throw new IOException("Impossible to put myself to sleep");
    }

    protected Connect connection() throws VirtException {
        if (this.connect == null) {
            try {
                String connectionString = this.getEmulator().getConnectionString();
                if (this.getUser().getAuthMethod().length() > 0) {
                    connectionString = connectionString.replace("#{auth.sep}", "+");
                    connectionString = connectionString.replace("#{auth.method}", this.getUser().getAuthMethod());
                } else {
                    connectionString = connectionString.replace("#{auth.sep}", "");
                    connectionString = connectionString.replace("#{auth.method}", "");
                }
                connectionString = connectionString.replace("#{user.name}", this.getUser().getName());
                connectionString = connectionString.replace("#{target.host}", this.getIpAddress());
                System.out.println("Connecting to " + connectionString);
                this.connect = new Connect(connectionString);
            }
            catch (VirtException e) {
                System.out.println("exception caught:" + e);
                throw e;
            }
        }
        return this.connect;
    }

    private void populate() throws VirtException {
        try {
            this.populateStoragePools(this.connection().listStoragePools());
            this.populateDomain(this.connection().listDomains());
            this.populateDomain(this.connection().listDefinedDomains());
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            throw e;
        }
    }

    private void populateStoragePools(String[] poolsNames) throws VirtException {
        for (String poolName : poolsNames) {
            this.populateStoragePool(poolName);
        }
    }

    private void populateStoragePool(String name) throws VirtException {
        LibVirtStoragePool gfPool = new LibVirtStoragePool(this, this.connection().storagePoolLookupByName(name));
        this.storagePools.put(name, gfPool);
    }

    private void populateDomain(int[] domainIds) throws VirtException {
        for (int domainId : domainIds) {
            this.addDomain(this.connection().domainLookupByID(domainId));
        }
    }

    private void populateDomain(String[] domainIds) throws VirtException {
        for (String domainId : domainIds) {
            this.addDomain(this.connect.domainLookupByName(domainId));
        }
    }

    private void addDomain(Domain domain) throws VirtException {
        String domainName = domain.getName();
        if (!this.domains.containsKey(domainName)) {
            LibVirtVirtualMachine gfVM = new LibVirtVirtualMachine(this, domain, null);
            this.domains.put(domainName, gfVM);
        }
    }

    @Override
    public Future<VirtualMachine> create(Template template, VirtualCluster cluster) throws VirtException, IOException {
        this.populate();
        String name = cluster.getConfig().getName() + cluster.allocateToken();
        File xml = new File(this.virtualizations.getTemplatesLocation(), template.getName() + ".xml");
        Element vmConfig = this.loadConfigFile(xml);
        List<StorageVol> volumes = this.prepare(template, name, cluster);
        File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.group.getName()));
        machineDisks = new File(machineDisks, this.getName());
        File custDirectory = this.prepareCustDirectory(name, cluster, template);
        File custFile = new File(machineDisks, name + "cust.iso");
        Disk custDisk = this.prepareCustomization(custDirectory, custFile, name);
        String diskLocation = this.config.getDisksLocation();
        this.delete(diskLocation + "/" + custFile.getName());
        this.copy(custFile, new File(diskLocation));
        OsInterface os = (OsInterface)this.habitat.getComponent(OsInterface.class);
        String uuid = UUID.randomUUID().toString();
        String macAddress = os.macAddressGen();
        vmConfig.setAttribute("type", this.getEmulator().getVirtType());
        NodeList children = vmConfig.getChildNodes();
        for (int k = 0; k < children.getLength(); ++k) {
            Node node = children.item(k);
            if (node.getNodeName().equals("name")) {
                node.getChildNodes().item(0).setNodeValue(name);
            }
            if (node.getNodeName().equals("uuid")) {
                node.getChildNodes().item(0).setNodeValue(uuid);
            }
            if (!node.getNodeName().equals("devices")) continue;
            NodeList devices = node.getChildNodes();
            for (int i = 0; i < devices.getLength(); ++i) {
                Node device = devices.item(i);
                if (device.getNodeName().equals("disk")) {
                    node.removeChild(device);
                }
                if (device.getNodeName().equals("interface") && device.getAttributes().getNamedItem("type").getNodeValue().equals("bridge")) {
                    NodeList intfInfos = device.getChildNodes();
                    for (int j = 0; j < intfInfos.getLength(); ++j) {
                        if (!intfInfos.item(j).getNodeName().equals("mac")) continue;
                        intfInfos.item(j).getAttributes().getNamedItem("address").setNodeValue(macAddress);
                    }
                }
                if (!device.getNodeName().equals("emulator")) continue;
                device.getChildNodes().item(0).setNodeValue(this.getEmulator().getEmulatorPath());
            }
            int position = 0;
            for (StorageVol aVol : volumes) {
                if (!(aVol instanceof LibVirtStorageVol)) continue;
                Node newNode = ((LibVirtStorageVol)aVol).getXML(node, position++);
                node.appendChild(newNode);
            }
            CDRomDisk cdRom = new CDRomDisk();
            Node cdRomNode = cdRom.save(this.getUserHome() + "/" + this.config.getDisksLocation() + "/" + custFile.getName(), node, 0);
            node.appendChild(cdRomNode);
        }
        File destXml = new File("/tmp/foo.xml");
        this.writeConfig(vmConfig, destXml);
        System.out.println("I would use " + uuid + " id with mac " + macAddress);
        try {
            Domain domain = this.connection().domainDefineXML(this.getConfig(vmConfig));
            final CountDownLatch latch = new CountDownLatch(1);
            final LibVirtVirtualMachine vm = new LibVirtVirtualMachine(this, domain, latch);
            this.domains.put(name, vm);
            vm.start();
            return new Future<VirtualMachine>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return latch.getCount() != 0L;
                }

                @Override
                public VirtualMachine get() throws InterruptedException, ExecutionException {
                    latch.await();
                    return vm;
                }

                @Override
                public VirtualMachine get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    latch.await(timeout, unit);
                    return vm;
                }
            };
        }
        catch (VirtException e) {
            for (StorageVol volume : volumes) {
                volume.delete();
            }
            throw new VirtException(e);
        }
    }

    private Element loadConfigFile(File xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(xml);
            return document.getDocumentElement();
        }
        catch (IOException ex) {
            this.handleError(ex);
        }
        catch (SAXException ex) {
            this.handleError(ex);
        }
        catch (ParserConfigurationException ex) {
            this.handleError(ex);
        }
        catch (FactoryConfigurationError ex) {
            this.handleError(ex);
        }
        return null;
    }

    private void writeConfig(Node doc, File destination) {
        try {
            this.write(doc, new StreamResult(destination));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getConfig(Node doc) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(doc, new StreamResult(baos));
            return baos.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void write(Node doc, Result result) throws TransformerException {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(new DOMSource(doc), result);
    }

    private void handleError(Throwable e) {
        e.printStackTrace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TemplateTask
    implements Callable<Void> {
        private TemplateTask() {
        }

        @Override
        public Void call() throws Exception {
            for (VMTemplate template : LibVirtLocalMachine.this.installedTemplates.values()) {
                try {
                    if (!template.isLocal()) continue;
                    template.copyTo(LibVirtLocalMachine.this, LibVirtLocalMachine.this.config.getTemplatesLocation());
                    LibVirtLocalMachine.this.installedTemplates.put(template.getDefinition().getName(), new RemoteTemplate(LibVirtLocalMachine.this, LibVirtLocalMachine.this.config.getTemplatesLocation(), template.getDefinition()));
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

