/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.virtualization.libvirt.LibVirtStorageVol;
import org.glassfish.virtualization.libvirt.jna.StoragePool;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.VirtException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibVirtStoragePool
implements org.glassfish.virtualization.spi.StoragePool {
    private final Machine owner;
    private final StoragePool pool;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    LibVirtStoragePool(Machine owner, StoragePool pool) {
        this.owner = owner;
        this.pool = pool;
    }

    Machine getMachine() {
        return this.owner;
    }

    public Iterable<LibVirtStorageVol> volumes() throws VirtException {
        ArrayList<LibVirtStorageVol> volumes = new ArrayList<LibVirtStorageVol>();
        for (String volumeID : this.pool.listVolumes()) {
            volumes.add(new LibVirtStorageVol(this, this.pool.storageVolLookupByName(volumeID)));
        }
        return volumes;
    }

    @Override
    public LibVirtStorageVol allocate(String name, long capacity) throws VirtException {
        StringBuilder sb = new StringBuilder();
        sb.append("<volume><name>").append(name).append(".img").append("</name> <key>").append(this.owner).append("/").append(name).append(".img").append("</key><source></source><capacity>").append(capacity).append("</capacity><allocation>0</allocation>").append("<target><path>").append(this.owner).append("/").append(name).append(".img</path>").append("<format type='raw'/><permissions><mode>0600</mode><owner>").append(this.owner.getUser().getUserId()).append("</owner><group>").append(this.owner.getUser().getGroupId()).append("</group></permissions></target></volume>");
        return new LibVirtStorageVol(this, this.pool.storageVolCreateXML(sb.toString(), 0));
    }

    @Override
    public LibVirtStorageVol byName(String name) throws VirtException {
        try {
            for (String volumeID : this.pool.listVolumes()) {
                if (!volumeID.equals(name)) continue;
                return new LibVirtStorageVol(this, this.pool.storageVolLookupByName(volumeID));
            }
            return null;
        }
        catch (VirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public void delete() throws VirtException {
        if (!this.valid.compareAndSet(true, false)) {
            return;
        }
        for (LibVirtStorageVol volume : this.volumes()) {
            volume.delete();
        }
        this.pool.delete(0);
    }
}

