/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.virtualization.libvirt.jna.Domain;
import org.glassfish.virtualization.libvirt.jna.DomainInfo;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MemoryListener;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.spi.VirtualMachineInfo;
import org.glassfish.virtualization.util.RuntimeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtVirtualMachine
implements VirtualMachine {
    private final Machine owner;
    final Domain domain;
    final String name;
    private String address;
    private CountDownLatch latch;

    protected LibVirtVirtualMachine(Machine owner, Domain domain, CountDownLatch latch) throws VirtException {
        this.domain = domain;
        this.owner = owner;
        this.latch = latch;
        this.name = domain.getName();
    }

    @Override
    public void setAddress(String address) {
        if (this.latch != null) {
            this.latch.countDown();
            this.latch = null;
        }
        this.address = address;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void start() throws VirtException {
        this.domain.create();
    }

    @Override
    public void stop() throws VirtException {
        if (DomainInfo.DomainState.VIR_DOMAIN_RUNNING.equals((Object)this.domain.getInfo().getState())) {
            this.domain.destroy();
        }
    }

    @Override
    public void resume() throws VirtException {
        this.domain.resume();
    }

    @Override
    public void suspend() throws VirtException {
        this.domain.suspend();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() throws VirtException {
        try {
            this.stop();
        }
        catch (VirtException e) {
            e.printStackTrace();
        }
        for (StorageVol volume : this.volumes()) {
            volume.delete();
        }
        this.domain.undefine();
    }

    public Iterable<StorageVol> volumes() throws VirtException {
        ArrayList<StorageVol> volumes = new ArrayList<StorageVol>();
        for (StoragePool storagePool : this.owner.getStoragePools().values()) {
            for (StorageVol storageVol : storagePool.volumes()) {
                if (!storageVol.getName().startsWith(this.getName())) continue;
                volumes.add(storageVol);
            }
        }
        return volumes;
    }

    @Override
    public VirtualMachineInfo getInfo() {
        return new VirtualMachineInfo(){
            private final Map<MemoryListener, ScheduledFuture> listeners = new HashMap<MemoryListener, ScheduledFuture>();

            public int nbVirtCpu() throws VirtException {
                try {
                    return LibVirtVirtualMachine.this.domain.getInfo().nrVirtCpu;
                }
                catch (VirtException e) {
                    throw new VirtException(e);
                }
            }

            public long memory() throws VirtException {
                try {
                    return LibVirtVirtualMachine.this.domain.getInfo().memory.longValue();
                }
                catch (VirtException e) {
                    throw new VirtException(e);
                }
            }

            public long maxMemory() throws VirtException {
                try {
                    return LibVirtVirtualMachine.this.domain.getInfo().maxMem.longValue();
                }
                catch (VirtException e) {
                    throw new VirtException(e);
                }
            }

            public Machine.State getState() throws VirtException {
                try {
                    DomainInfo.DomainState state = DomainInfo.DomainState.values()[LibVirtVirtualMachine.this.domain.getInfo().state];
                    if (DomainInfo.DomainState.VIR_DOMAIN_RUNNING.equals((Object)state) || DomainInfo.DomainState.VIR_DOMAIN_BLOCKED.equals((Object)state)) {
                        return Machine.State.READY;
                    }
                    if (DomainInfo.DomainState.VIR_DOMAIN_SHUTDOWN.equals((Object)state)) {
                        return Machine.State.SUSPENDING;
                    }
                    return Machine.State.SUSPENDED;
                }
                catch (VirtException e) {
                    throw new VirtException(e);
                }
            }

            public void registerMemoryListener(final MemoryListener ml, long period, TimeUnit unit) {
                ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                final LibVirtVirtualMachine owner = LibVirtVirtualMachine.this;
                this.listeners.put(ml, executor.schedule(new Runnable(){

                    public void run() {
                        try {
                            ml.notified(owner, this.memory());
                        }
                        catch (VirtException e) {
                            RuntimeContext.logger.log(Level.FINE, "Exception while notifying of vm load ", e);
                        }
                    }
                }, period, unit));
            }

            public void unregisterMemoryListener(MemoryListener ml) {
                this.listeners.get(ml).cancel(false);
            }
        };
    }
}

